#include <misc.h>
#include <module_apis/dhcp_api.h>
#include "dhcpd.h"

class DHCP_API_PRIV: public DHCP_API{
public:
	LEASES *leases;
	DHCP_API_PRIV(){
		leases = NULL;
	}
	~DHCP_API_PRIV(){
		delete leases;
	}
};

/*
	Get the IP address associated with a MAC
	Return -1 if not found
*/
static int api_getip (DHCP_API *o, const char *mac, SSTRING &ip)
{
	int ret = -1;
	DHCP_API_PRIV *api = (DHCP_API_PRIV*)o;
	if (api->leases == NULL) api->leases = new LEASES;
	if (api->leases != NULL){
		for (int i=api->leases->getnb()-1; i >= 0; i--){
			LEASE *l = api->leases->getitem(i);
			if (l->mac.icmp(mac)==0){
				ret = 0;
				ip.setfrom (l->ip);
				break;
			}
		}
	}
	return ret;
}
/*
	Release the IP address associated with a MAC
	Return -1 if not found.
*/
int api_release (DHCP_API *o, const char *mac)
{
	return 0;
}



void *dhcp_api_get ()
{
	DHCP_API *api = new DHCP_API_PRIV;
	api->getip = api_getip;
	api->release = api_release;
	return api;
}

void dhcp_api_release (void *obj)
{
	DHCP_API *api = (DHCP_API*)obj;
	DHCP_API_PRIV *priv = (DHCP_API_PRIV*)api;
	delete priv;
}

