#include "internal.h"
#include "apache.m"
#include "keyword.h"

static APACHE_HELP_FILE help_apache_ssl ("apache_ssl");

void protocomb(FIELD_COMBO &comb) {
	comb.addopt("SSLv2","");
	comb.addopt("SSLv3","");
	comb.addopt("TLSv1","");
	comb.addopt("All","");
}

void verifyclientcomb(FIELD_COMBO &comb) {
	comb.addopt("none","");
	comb.addopt("optional","");
	comb.addopt("require","");
	comb.addopt("optional_no_ca","");
}

void loglevelcomb(FIELD_COMBO &comb) {
	comb.addopt("none","");
	comb.addopt("error","");
	comb.addopt("warn","");
	comb.addopt("info","");
	comb.addopt("trace","");
	comb.addopt("debug","");
}

PUBLIC int HTTPD_CONFIG::ssl_edit()
{
	int ret = -1, nof = 0;
	DIALOG dia;
        VIEW_SECTION sec ("IfModule",itemss);
        sec.setview ("mod_ssl.c");
	VIEWEDIT vedit (sec,dia);

	dia.newf_title ("",MSG_R(T_SSLOPTIONS));
	vedit.newf_str (MSG_U(F_SSLPASSPHRASE,"Pass Phrase Dialog")
		,K_SSLPASSPHRASEDIALOG);
        vedit.newf_str (MSG_U(F_SSLSESSIONCACHE,"Session Cache"),K_SSLSESSIONCACHE);
	vedit.newf_str (MSG_U(F_SSLMUTEX,"SSL Mutex"),K_SSLMUTEX);
	ssl_setdia(vedit, false);

	SSTRING_IDXS RandomSeed;
	sec.locate_all (K_SSLRANDOMSEED,RandomSeed);
        for(int i=0; i<RandomSeed.getnb(); i++){
		SSTRING *cs = RandomSeed.getitem(i);
		dia.newf_str(MSG_U(F_SSLRANDOMSEED,"Random Seed"),*cs);
	}
	while (1){
		MENU_STATUS code = dia.edit (
			MSG_U(T_APACHESSL,"Apache SSL Configuration")
			,MSG_U(I_APACHESSL,"You can configure mod_ssl options in your Apache Server")
			,help_apache_ssl
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			ret = 0;
			vedit.update("");
			write();
			break;
		}
	}
	if (ret == -1) dia.restore();
	return ret;
}

