#ifndef XDATA_H
#define XDATA_H

#ifndef MISC_H
	#include <misc.h>
#endif

#define MODEL	0
#define LAYOUT	1

#include "Xkbdconf.m"
#include "devicelist.h"

class XDATA: public ARRAY_OBJ{
public:
	SSTRING *name;
	SSTRING *desc;
	char tpo; //type M for models or L for layout
	
public:
	XDATA(SSTRING *_name, SSTRING *_desc, char _tpo);
	XDATA(void);
	~XDATA();
};

class XDATALIST: public ARRAY{
public:
	SSTRING nameModel;
	SSTRING nameLayout;
	char *defnameModel;
	char *defnameLayout;
private:
	const char *cmd;

public:
	XDATALIST (void);
	~XDATALIST();
	XDATA *getitem(int no);

public:
	int init();
	int save();
	int save(const char *model, const char *layout);
	void getlistmodels(SSTRINGS &dest);
	void getlistlayouts(SSTRINGS &dest);
	const char *getmodeldescbyname(const char *name);
	const char *getmodelnamebydesc(const char *desc);
	const char *getlayoutdescbyname(const char *name);
	const char *getlayoutnamebydesc(const char *desc);
	int restoretodefault();
	int cantouchdisplay();
	int updatekeyboard();
	const char *touch();
	int isXcfgaccessible();
	int setXmodelconfig(const char *model);
	int setXmodelconfig();
	int setXlayoutconfig(const char *layout);
	int setXlayoutconfig();
	int populateKeyboardConfig(DEVICELIST &dev);
	int version_compatible();
	const char *getlayout();
	int isXFconfigaccessible();

private:
	int execlist (SSTRINGS &st, const char *command, const char *args);
	int getXFitem(SSTRING &s, const char *command, const char *args);
};

#endif
