#pragma implementation

#include "modapi.h"

#include "internal.h"
#undef DIALOG_H
#include <dialog.h>

PUBLIC M_FIELD_COMBO::M_FIELD_COMBO (FIELD_COMBO *_real, M_FIELD_COMBO *first)
{
	next = first;
	real = _real;
}

PUBLIC void M_FIELD_COMBO::addopt (const char *str)
{
	real->addopt (str);
}
PUBLIC void M_FIELD_COMBO::addopt (
	const char *value,
	const char *verbose)
{
	real->addopt (value,verbose);
}

PUBLIC void M_FIELD_COMBO::addopts(const SSTRINGS &lst)
{
	real->addopts (lst);
}
PUBLIC void M_FIELD_COMBO::addopts(const SSTRING_KEYS &lst)
{
	real->addopts (lst);
}


PUBLIC M_FIELD_LIST::M_FIELD_LIST (FIELD_LIST *_real, M_FIELD_LIST *first)
{
	next = first;
	real = _real;
}

PUBLIC void M_FIELD_LIST::addopt (const char *str)
{
	real->addopt (str);
}
PUBLIC void M_FIELD_LIST::addopt (
	const char *value,
	const char *verbose)
{
	real->addopt (value,verbose);
}
PUBLIC void M_FIELD_LIST::addopt (
	const char *value,
	const char *shown,
	const char *verbose)
{
	real->addopt (value,shown,verbose);
}



PUBLIC M_FIELD_COMBO_MANY::M_FIELD_COMBO_MANY (FIELD_COMBO_MANY *_real, M_FIELD_COMBO_MANY *first)
{
	next = first;
	real = _real;
}
PUBLIC M_FIELD_ENUM::M_FIELD_ENUM (FIELD_ENUM *_real, M_FIELD_ENUM *first)
{
	next = first;
	real = _real;
}

PUBLIC void M_FIELD_ENUM::addopt (const char *str)
{
	real->addopt (str);
}
PUBLIC void M_FIELD_ENUM::addopt (
	const char *value,
	const char *verbose)
{
	real->addopt (value,verbose);
}

PUBLIC M_FIELD_CLIST::M_FIELD_CLIST (FIELD_CLIST *_real, M_FIELD_CLIST *first)
{
	next = first;
	real = _real;
}

PUBLIC void M_FIELD_CLIST::setheader(const char *s)
{
	real->setheader (s);
}
PUBLIC void M_FIELD_CLIST::addrecord (const char *s)
{
	real->addrecord (s);
}

PUBLIC void M_FIELD_CLIST::addrecordf (const char *s, ...)
{
	va_list list;
	va_start (list,s);
	real->vaddrecordf (s,list);
	va_end (list);
}
PUBLIC void M_FIELD_CLIST::insrecord (int pos, const char *s)
{
	real->insrecord (pos,s);
}

PUBLIC void M_FIELD_CLIST::setrecord (int no, const char *s)
{
	real->setrecord (no,s);
}

PUBLIC void M_FIELD_CLIST::setrecordf (int pos, const char *s, ...)
{
	va_list list;
	va_start (list,s);
	real->vsetrecordf (pos,s,list);
	va_end (list);
}


PUBLIC int M_FIELD_CLIST::getnb () const
{
	return real->getnb();
}
PUBLIC const char *M_FIELD_CLIST::getline (int no) const
{
	return real->getline(no);
}

PUBLIC void M_FIELD_CLIST::setcursor (int pos,bool focus)
{
	real->setcursor (pos,focus);
}



PUBLIC void M_DIALOG::newf_chk (
	const char *prompt,
	char &var,
	const char *title)
{
	real->newf_chk (prompt,var,title);
}
PUBLIC void M_DIALOG::newf_chkm (
	const char *prompt,
	char &var,
	const char *title[])
{
	real->newf_chkm(prompt,var,title);
}

PUBLIC void M_DIALOG::newf_chkm_num (
	const char *prompt,
	int &var,
	const int vals[],
	const char *title[])
{
	real->newf_chkm_num(prompt,var,vals,title);
}

PUBLIC void M_DIALOG::newf_chkm_num (
	const char *prompt,
	int &var,
	const int defvar,
	const int vals[],
	const char *title[])
{
	real->newf_chkm_num(prompt,var,defvar,vals,title);
}

PUBLIC void M_DIALOG::newf_chkm_col (
	const char *prompt,
	char &var,
	const char *title[])

{
	newf_chkm_col(prompt,var,title);
}

PUBLIC void M_DIALOG::save ()
{
	real->save();
}
PUBLIC void M_DIALOG::reload ()
{
	real->reload();
}
PUBLIC void M_DIALOG::reload (int no)
{
	real->reload(no);
}
PUBLIC void M_DIALOG::reload (int start, int end)
{
	real->reload(start,end);
}
PUBLIC void M_DIALOG::restore ()
{
	real->restore();
}
PUBLIC void M_DIALOG::set_readonly ()
{
	real->set_readonly();
}
PUBLIC void M_DIALOG::set_lastreadonly ()
{
	real->set_lastreadonly();
}
PUBLIC void M_DIALOG::last_noempty ()
{
	real->last_noempty();
}
PUBLIC int M_DIALOG::was_modified ()
{
	return real->was_modified();
}

PUBLIC void M_DIALOG::seticon (const char *_icon)
{
	real->seticon(_icon);
}
PUBLIC void M_DIALOG::setbutinfo (
	int id,
	const char *title,
	const char *icon)
{
	real->setbutinfo(id,title,icon);
}
PUBLIC void M_DIALOG::html_body (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	real->vhtml_body (ctl,list);
	va_end (list);
}
PUBLIC void M_DIALOG::html_intro (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	real->vhtml_intro (ctl,list);
	va_end (list);
}
PUBLIC void M_DIALOG::html_top (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	real->vhtml_top (ctl,list);
	va_end (list);
}

PUBLIC void M_DIALOG::html_end (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	real->vhtml_end (ctl,list);
	va_end (list);
}
PUBLIC void M_DIALOG::set_alt_title (const char *_title)
{
	real->set_alt_title(_title);
}
PUBLIC void M_DIALOG::setsidetitle (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	real->vsetsidetitle (ctl,list);
	va_end (list);
}

PUBLIC M_FIELD_COMBO *M_DIALOG::newf_combo (
	const char *prompt,
	SSTRING &str)
{
	FIELD_COMBO *comb = real->newf_combo (prompt,str);
	M_FIELD_COMBO *ret = new M_FIELD_COMBO (comb,internal->combo);
	internal->combo = ret;
	return ret;
}
PUBLIC M_FIELD_COMBO *M_DIALOG::newf_combo (
	const char *prompt,
	SSTRING &str,
	int maxsiz)
{
	FIELD_COMBO *comb = real->newf_combo (prompt,str,maxsiz);
	M_FIELD_COMBO *ret = new M_FIELD_COMBO (comb,internal->combo);
	internal->combo = ret;
	return ret;
}

PUBLIC M_FIELD_LIST *M_DIALOG::newf_list (
	const char *prompt,
	SSTRING &str)
{
	FIELD_LIST *list = real->newf_list (prompt,str);
	M_FIELD_LIST *ret = new M_FIELD_LIST (list,internal->list);
	internal->list = ret;
	return ret;
}
PUBLIC M_FIELD_ENUM *M_DIALOG::newf_enum (const char *prompt, int &sel)
{
	FIELD_ENUM *fenum = real->newf_enum (prompt,sel);
	M_FIELD_ENUM *ret = new M_FIELD_ENUM (fenum,internal->fenum);
	internal->fenum = ret;
	return ret;
}
PUBLIC M_FIELD_COMBO_MANY *M_DIALOG::newf_combo_many (
	const char *prompt,
	SSTRING &str)
{
	FIELD_COMBO_MANY *fmany = real->newf_combo_many (prompt,str);
	M_FIELD_COMBO_MANY *ret = new M_FIELD_COMBO_MANY (fmany,internal->fmany);
	internal->fmany = ret;
	return ret;
}

PUBLIC M_FIELD_CLIST *M_DIALOG::newf_clist (
	const char *prompt,
	int nbvisible,
	PRIVATE_MESSAGE &msg,
	int &sel)
{
	FIELD_CLIST *fclist = real->newf_clist (prompt,nbvisible,msg,sel);
	M_FIELD_CLIST *ret = new M_FIELD_CLIST (fclist,internal->clist);
	internal->clist = ret;
	return ret;
}

PUBLIC int M_DIALOG::remove_del (int no)
{
	return real->remove_del (no);
}

PUBLIC void M_DIALOG::newf_str (
	const char *prompt,
	char *str,
	int maxsiz)
{
	real->newf_str(prompt,str,maxsiz);
}
PUBLIC void M_DIALOG::newf_str (
	const char *prompt,
	SSTRING &str)
{
	real->newf_str(prompt,str);
}
PUBLIC void M_DIALOG::newf_str (
	const char *prompt,
	SSTRING &str,
	int width)
{
	real->newf_str(prompt,str,width);
}
PUBLIC void M_DIALOG::newf_pass (
	const char *prompt,
	SSTRING &str)
{
	real->newf_pass(prompt,str);
}
PUBLIC void M_DIALOG::newf_num (const char *prompt, int &val)
{
	real->newf_num(prompt,val);
}
PUBLIC void M_DIALOG::newf_hexnum (const char *prompt, int &val)
{
	real->newf_hexnum (prompt,val);
}
PUBLIC void M_DIALOG::newf_octnum (const char *prompt, int &val)
{
	real->newf_octnum (prompt,val);
}
PUBLIC void M_DIALOG::newf_dbl (
	const char *prompt,
	double &val,
	int nbdecimals)
{
	real->newf_dbl (prompt,val,nbdecimals);
}
PUBLIC void M_DIALOG::newf_slider (
	const char *prompt,
	int &val,
	int minval,
	int maxval)
{
	real->newf_slider(prompt,val,minval,maxval);
}
PUBLIC void M_DIALOG::newf_gauge (
	const char *prompt,
	int &val,
	int range)
{
	real->newf_gauge (prompt,val,range);
}


PUBLIC void M_DIALOG::newf_title (
	const char *pad,
	int level,
	const char *prompt,
	const char *msg)
{
	real->newf_title (pad,level,prompt,msg);
}
PUBLIC void M_DIALOG::newf_title (const char *prompt, const char *msg)
{
	real->newf_title (prompt,msg);
}
PUBLIC void M_DIALOG::newf_head (const char *prompt, const char *msg)
{
	real->newf_head (prompt,msg);
}
PUBLIC void M_DIALOG_RECORDS::newf_head (const char *prompt, const char *msg)
{
	((DIALOG_RECORDS*)real)->newf_head (prompt,msg);
}
PUBLIC void M_DIALOG::new_menuline (
	const char *icon,
	const char *prompt1,
	const char *prompt2,
	bool may_select)
{
	real->new_menuline (icon,prompt1,prompt2,may_select);
}
PUBLIC void M_DIALOG::new_menuitem (
	const char *prompt1,
	const char *prompt2)
{
	real->new_menuitem (prompt1,prompt2);
}
PUBLIC void M_DIALOG::set_menuitem (
	int no,
	const char *prompt1,
	const char *prompt2)
{
	real->set_menuitem (no,prompt1,prompt2);
}
PUBLIC void M_DIALOG::new_menuitem (
	const char *icon,
	const char *prompt1,
	const char *prompt2)
{
	real->new_menuitem (icon,prompt1,prompt2);
}
PUBLIC void M_DIALOG::new_menuinfo (
	const char *prompt1,
	const char *prompt2)
{
	real->new_menuinfo(prompt1,prompt2);
}
PUBLIC void M_DIALOG::new_menuitem (
	const char *prompt1,
	const SSTRING &prompt2)
{
	real->new_menuitem (prompt1,prompt2);
}
PUBLIC void M_DIALOG::new_menuitem (
	const SSTRING &prompt1,
	const SSTRING &prompt2)
{
	real->new_menuitem (prompt1,prompt2);
}
PUBLIC void M_DIALOG::new_menuitems (const char *items[], int item_no)
{
	real->new_menuitems (items,item_no);
}
PUBLIC void M_DIALOG::new_menuitems (const char *opt[])
{
	real->new_menuitems (opt);
}
PUBLIC const char *M_DIALOG::getmenustr (int choice)
{
	return real->getmenustr (choice);
}
PUBLIC void M_DIALOG::savewhat (const char *help)
{
	real->savewhat (help);
}
PUBLIC void M_DIALOG::delwhat (const char *help)
{
	real->delwhat (help);
}
PUBLIC void M_DIALOG::inswhat (const char *help)
{
	real->inswhat(help);
}
PUBLIC void M_DIALOG::addwhat (const char *help)
{
	real->addwhat (help);
}
PUBLIC void M_DIALOG::setheight_hint()
{
	real->setheight_hint();
}

PUBLIC MENU_STATUS M_DIALOG::editmenu (
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,
	int options)
{
	return real->editmenu (title,prompt,helpfile,sel,options);
}
/*
	Used by modules
*/
PUBLIC M_DIALOG::M_DIALOG ()
{
	internal = new M_DIALOG_INTERNAL;
	real = new DIALOG;
	own_real = true;
}


/*
	Use to create a insulator for an existing DIALOG object
*/
PUBLIC M_DIALOG::M_DIALOG (DIALOG *_real)
{
	internal = new M_DIALOG_INTERNAL;
	real = _real;
	own_real = false;
}
PUBLIC M_DIALOG::~M_DIALOG ()
{
	delete internal;
	if (own_real) delete real;
}
PUBLIC MENU_STATUS M_DIALOG::edit (
	const char *_title,
	const char *_intro,
	HELP_FILE &helpfile,
	int &nof,
	int but_options)
{
	return real->edit (_title,_intro,helpfile,nof,but_options);
}
PUBLIC void M_DIALOG::show (
	const char *_title,
	const char *_intro,
	HELP_FILE &helpfile,
	int &nof,
	int but_options)
{
	real->show (_title,_intro,helpfile,nof,but_options);
}
PUBLIC MENU_STATUS M_DIALOG::edit (
	const char *_title,
	const char *_intro,
	HELP_FILE &helpfile)
{
	return real->edit (_title,_intro,helpfile);
}
PUBLIC MENU_STATUS M_DIALOG::edit (
	const char *_title,
	const char *_intro,
	HELP_FILE &helpfile,
	int &nof)
{
	return real->edit (_title,_intro,helpfile,nof);
}
PUBLIC void M_DIALOG::newf_radio (
	const char *prompt,
	char &var,
	char instance_val,
	const char *title)
{
	real->newf_radio (prompt,var,instance_val,title);
}

PUBLIC void M_DIALOG::remove_all()
{
	real->remove_all();
}

PUBLIC int M_DIALOG::getnb()
{
	return real->getnb();
}

PROTECTED M_DIALOG::M_DIALOG (int)
{
	real = NULL;
	internal = NULL;
	own_real = true;
}

PUBLIC void M_DIALOG_MENU::setmenu (MENU_CONTEXT ctx)
{
	((DIALOG_MENU*)real)->setmenu (ctx);
}

PUBLIC M_DIALOG_RECORDS::M_DIALOG_RECORDS ()
	: M_DIALOG (0)
{
	internal = new M_DIALOG_INTERNAL;
	real = new DIALOG_RECORDS;
}
PROTECTED M_DIALOG_RECORDS::M_DIALOG_RECORDS (int )
	: M_DIALOG (0)
{
}
PUBLIC MENU_STATUS M_DIALOG_RECORDS::editmenu (
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,
	int options)
{
	return ((DIALOG_RECORDS*)real)->editmenu (title,prompt,helpfile,sel,options);
}

PUBLIC void M_DIALOG_RECORDS::setkeyformat (HTML_KEY_TYPE key_type)
{
	((DIALOG_RECORDS*)real)->setkeyformat(key_type);
}

PUBLIC M_DIALOG_LISTE::M_DIALOG_LISTE ()
	: M_DIALOG_RECORDS (0)
{
	internal = new M_DIALOG_INTERNAL;
	real = new DIALOG_LISTE;
}
PUBLIC MENU_STATUS M_DIALOG_LISTE::editmenu (
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,
	int options)
{
	return ((DIALOG_LISTE*)real)->editmenu (title,prompt,helpfile,sel,options);
}

PUBLIC void M_DIALOG_LISTE::set_menuitem (int no, const char *p1, const char *p2)
{
	((DIALOG_LISTE*)real)->set_menuitem (no,p1,p2);
}

PUBLIC MENU_STATUS M_DIALOG_MENU::editmenu (
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int &sel,
	int options)
{
	return ((DIALOG_MENU*)real)->editmenu (title,prompt,helpfile,sel,options);
}

PUBLIC M_DIALOG_MENU::M_DIALOG_MENU ()
	: M_DIALOG (0)
{
	internal = new M_DIALOG_INTERNAL;
	real = new DIALOG_MENU;
}

PUBLIC M_DIALOG_MENUPOPUP::M_DIALOG_MENUPOPUP ()
	: M_DIALOG (0)
{
	internal = new M_DIALOG_INTERNAL;
	real = new DIALOG_MENUPOPUP;
}

PUBLIC MENU_STATUS M_DIALOG_MENUPOPUP::editmenu (const char *title, int &sel)
{
	return ((DIALOG_MENUPOPUP*)real)->editmenu(title, sel);
}


PUBLIC void M_DIALOG::gui_passthrough(
	int command,
	const char *args,
	...)
{
	va_list list;
	va_start (list,args);
	real->gui_passthroughv (command,args,list);
	va_end (list);
}

PUBLIC void M_DIALOG::newline()
{
	real->newline();
}
PUBLIC void M_DIALOG::gui_label(const char *ctl,...)
{
	va_list list;
	va_start (list,ctl);
	real->gui_labelv (ctl,list);
	va_end (list);
}
PUBLIC void M_DIALOG::gui_end()
{
	real->gui_end();
}
PUBLIC void M_DIALOG::gui_group(const char *title)
{
	real->gui_group(title);
}
PUBLIC void M_DIALOG::gui_form()
{
	real->gui_form();
}
PUBLIC void M_DIALOG::gui_dispolast(
	GUI_H_DISPO dispoh,
	int nbcellh,
	GUI_V_DISPO dispov,
	int nbcellv)
{
	real->gui_dispolast (dispoh,nbcellh,dispov,nbcellv);
}

PUBLIC void M_DIALOG::newf_info (const char *prompt, const char *str)
{
	real->newf_info (prompt,str);
}
PUBLIC void M_DIALOG::newf_sheet (
	const char *prompt,
	const char *titles[],
	SSTRINGS &tb)
{
	real->newf_sheet(prompt,titles,tb);
}

/*
	Add a secondary help to the dialog.
*/
PUBLIC void M_DIALOG::addhelp(HELP_FILE &help, const char *title)
{
	real->addhelp(help,title);
}
/*
	Set the dialog type
*/
PUBLIC void M_DIALOG::settype(DIALOG_TYPE type)
{
	real->settype(type);
}


PUBLIC void M_DIALOG_TEXTBOX::newf_text (const char *prompt, const char *buftab)
{
	((DIALOG_TEXTBOX*)real)->newf_text (prompt,buftab);
}
PUBLIC void M_DIALOG_TEXTBOX::newf_text (const char *prompt, const SSTRINGS &tb)
{
	((DIALOG_TEXTBOX*)real)->newf_text (prompt,tb);
}

PUBLIC void M_DIALOG::newf_textarea (
	const char *prompt,
	SSTRING &text,
	int width,
	int height)
{
	real->newf_textarea (prompt,text,width,height);
}

PUBLIC void M_DIALOG::setcontext (const char *s)
{
	real->setcontext (s);
}

/*
	Remove the last entries of the array, after the "cut" first items
*/
PUBLIC void M_DIALOG::remove_last(int cut)
{
	real->remove_last (cut);
}

/*
	Hide the DIALOG from the screen. Only useful in graphic mode.
	No effect for other mode.
*/
PUBLIC void M_DIALOG::hide()
{
	real->hide();
}

PUBLIC void M_DIALOG::waitfor(const char *msg)
{
	real->waitfor (msg);
}
PUBLIC void M_DIALOG::waitfor(PRIVATE_MESSAGE &msg)
{
	real->waitfor (msg);
}
PUBLIC void M_DIALOG::waitfortimer(const char *id)
{
	real->waitfortimer (id);
}
PUBLIC void M_DIALOG::waitfortimer(PRIVATE_MESSAGE &msg)
{
	real->waitfortimer (msg);
}

PUBLIC void M_DIALOG::set_button_on_side()
{
	real->set_button_on_side();
}

PUBLIC void M_DIALOG::set_registry_id(const char *id)
{
	real->set_registry_id (id);
}

PUBLIC void M_DIALOG::set_selected_button (int button)
{
	real->set_selected_button(button);
}

PUBLIC void M_DIALOG::set_registry_key(const char* key)
{
	real->set_registry_key(key);
}

PUBLIC const char *M_DIALOG::setguiname(char tmp[200])
{
	return real->setguiname(tmp);
}

PUBLIC M_FIELD_BUTTON_TEXT::M_FIELD_BUTTON_TEXT (FIELD_BUTTON_TEXT *_real, M_FIELD_BUTTON_TEXT *first)
{
	next = first;
	real = _real;
}

PUBLIC M_FIELD_BUTTON_ICON::M_FIELD_BUTTON_ICON (FIELD_BUTTON_ICON *_real, M_FIELD_BUTTON_ICON *first)
{
	next = first;
	real = _real;
}


PUBLIC M_FIELD_BUTTON_TEXT *M_DIALOG::new_button (
	const char *str,	// Text of the button
	const char *help,	// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg,
	bool enter_action)
{
	FIELD_BUTTON_TEXT *f = real->new_button (str,help,msg,enter_action);
	M_FIELD_BUTTON_TEXT *ret = new M_FIELD_BUTTON_TEXT (f,internal->btext);
	internal->btext = ret;
	return ret;
	
}

PUBLIC M_FIELD_BUTTON_TEXT *M_DIALOG::new_button (
	const char *str,	// Text of the button
	const char *help,	// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg)
{
	return new_button (str,help,msg,false);
}

PUBLIC M_FIELD_BUTTON_ICON *M_DIALOG::new_button_icon (
	const char *icon,		// icon name, correponding to a xpm file
	const char *help,		// bubble test over the icon, optional
	PRIVATE_MESSAGE &msg)
{
	FIELD_BUTTON_ICON *f = real->new_button_icon (icon,help,msg);
	M_FIELD_BUTTON_ICON *ret = new M_FIELD_BUTTON_ICON (f,internal->bicon);
	internal->bicon = ret;
	return ret;
}

PUBLIC void M_FIELD_BUTTON_TEXT::settext (const char *text)
{
	real->settext(text);
}
PUBLIC void M_FIELD_BUTTON_ICON::settext (const char *icon)
{
	real->seticon(icon);
}


PUBLIC FIELD_CHECK_MULTI *M_DIALOG::newf_chkm_str(
	const char *prompt,
	int &var,
	SSTRING &bufstr,
	const int vals[],
	const char *options[])
{
	return real->newf_chkm_str (prompt,var,bufstr,vals,options);
}

PUBLIC void M_DIALOG::set_helpdia (PRIVATE_MESSAGE &msg)
{
	real->set_helpdia(msg);
}

PUBLIC void M_DIALOG::set_formparms(const char* parms, ...)
{
	va_list list;
	va_start (list,parms);
	real->vset_formparms(parms,list);
	va_end (list);
}
PUBLIC void M_DIALOG::set_guiparms(const char* parms, ...)
{
	va_list list;
	va_start (list,parms);
	real->vset_guiparms(parms,list);
	va_end (list);
}

PUBLIC void M_DIALOG::request_dump()
{
	real->request_dump();
}

PUBLIC void M_DIALOG::new_inputgrid (
	int x,
	int y,
	int cellwidth,
	int cellheight,
	int nbcellh,
	int nbcellv,
	PRIVATE_MESSAGE &msg)
{
	real->new_inputgrid (x,y,cellwidth,cellheight,nbcellh,nbcellv,msg);
}

PUBLIC void M_DIALOG::auto_newline(bool mode)
{
	real->auto_newline (mode);
}

PUBLIC void M_DIALOG::set_nextfield (int no)
{
	real->set_nextfield (no);
}
PUBLIC void M_DIALOG::setoffset (int offset)
{
	real->setoffset (offset);
}

PUBLIC int M_DIALOG::getoffset ()
{
	return real->getoffset();
}

PUBLIC void M_DIALOG::newf_ipnum (const char *prompt, SSTRING &ip)
{
	real->newf_ipnum (prompt,ip);
}

