#pragma implementation
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <misc.h>
#include "dialog.h"
#include "fcombo.h"
#include "dialog.m"
#include "../diajava/proto.h"

PUBLIC ELM_STR::ELM_STR(
	const char *_value,
	const char *_shown,
	const char *_verbose)
{
	value = strdup(_value);
	shown = strdup(_shown);
	verbose = strdup(_verbose);
}

PUBLIC ELM_STR::~ELM_STR()
{
	free (value);
	free (shown);
	free (verbose);
}

PUBLIC ELM_STR *LIST_STR::getitem(int no) const
{
	return (ELM_STR*)ARRAY::getitem(no);
}
/*
	Get the "significative" value associate of one item of the choice list
*/
PUBLIC const char *LIST_STR::getshown(int no) const
{
	const char *ret = "";
	ELM_STR *e = getitem(no);
	if (e != NULL){
		ret = e->shown;
	}
	return ret;
}
/* #Specification: FIELD_COMBO / principle
	The FIELD_COMBO class is a string editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.
*/
#
PUBLIC FIELD_COMBO::FIELD_COMBO(
	const char *_prompt,
	SSTRING &_str,
	int maxsiz)
	: FIELD_STRING_HELP (_prompt,_str,maxsiz)
{
	opts = new LIST_STR;
	listvalueonly = 0;
}

/* #Specification: FIELD_LIST / principle
	The FIELD_LIST class is a selector editor with an assist
	hot key. When triggered a list of string is displayed
	and the user is allowed to pick a value from there.
	The value (if selected) will replace the input buffer.

	The use may either use the input buffer to type the value or use
	the list, but the input has to come from the list.
*/
#
PUBLIC FIELD_LIST::FIELD_LIST(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_COMBO (_prompt,_str,30)
{
	listvalueonly = 1;
}

PUBLIC FIELD_COMBO::~FIELD_COMBO()
{
	delete opts;
}

/*
	Add one string option to the combo box pick list
*/
PUBLIC void FIELD_COMBO::addopt(const char *str)
{
	opts->add (new ELM_STR(str,str,""));
}
/*
	Add several string options to the combo box pick list
*/
PUBLIC void FIELD_COMBO::addopts(const SSTRINGS &lst)
{
	int n = lst.getnb();
	for (int i=0; i<n; i++){
		addopt (lst.getitem(i)->get());
	}
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_COMBO::addopt(const char *value, const char *verbose)
{
	opts->add (new ELM_STR(value,value,verbose));
}
PUBLIC void FIELD_LIST::addopt(const char *value, const char *verbose)
{
	FIELD_COMBO::addopt(value,verbose);
}
PUBLIC void FIELD_LIST::addopt(const char *str)
{
	FIELD_COMBO::addopt(str);
}
/*
	Add one string option with translation to the combo box pick list.
	This time there is two string. The strings will be show in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_LIST::addopt(
	const char *value,		// Real value we want in the edit variable
	const char *shown,		// Value presented to the user
	const char *verbose)	// Description of the value
{
	if (strcmp(buf,value)==0) strcpy (buf,shown);
	opts->add (new ELM_STR(value,shown,verbose));
}

/*
	Add several string options to the combo box pick list
*/
PUBLIC void FIELD_COMBO::addopts(const SSTRING_KEYS &lst)
{
	int n = lst.getnb();
	for (int i=0; i<n; i++){
		SSTRING_KEY *k = lst.getitem(i);
		addopt (k->get(),k->getobjval());
	}
}


PROTECTED void FIELD_COMBO::assist(WINDOW *dialog)
{
	int nbopt = opts->getnb();
	DIALOG dia;
	int nof = 0;
	for (int i=0; i<nbopt; i++){
		ELM_STR *elm = opts->getitem(i);
		const char *val = elm->shown;
		dia.new_menuitem (val,elm->verbose);
		if (strcmp(buf,val)==0) nof = i;
	}
	MENU_STATUS ret = dia.editmenu (MSG_U(T_HELPLIST,"Help list")
		,MSG_U(I_HELPLIST,"Pick one value")
		,help_nil
		,nof,0);
	touchwin(stdscr);
	touchwin(dialog);
	if (ret == MENU_OK && nof >=0 && nof < nbopt){
		strcpy (buf,opts->getshown(nof));
		draw(dialog,0);
	}
}

PUBLIC void FIELD_COMBO::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	if (readonly){
		html_printf ("%s\n",buf);
	}else{
		if (!listvalueonly){
			html_defvar ("text",key,buf,"size=30 maxlength=256");
		}
		html_defvarcur (key,buf);
		int n = opts->getnb();
		if (n > 0){	
			char sel_key[100];
			sprintf (sel_key,"SELECT_%s",key);
			html_defselect (sel_key);
			if (!listvalueonly) html_printf ("<OPTION VALUE=0>\n");
			for (int i=0; i<n; i++){
				int id = i+1;
				const char *vstr = opts->getshown(i);
				ELM_STR *e = opts->getitem(i);
				if (listvalueonly){
					html_printf ("<OPTION VALUE=%d %s>%s %s\n",id
						,strcmp(buf,vstr)==0 ? "selected" : ""
						,e->shown,e->verbose);
				}else{
					#if 0
						html_printf ("<OPTION VALUE=%d>%s\n",id,vstr);
					#else
						html_printf ("<OPTION VALUE=%d>%s %s\n",id
							,e->value,e->verbose);
					#endif
				}
			}
			html_printf ("</SELECT>\n");
		}
	}
}

PUBLIC void FIELD_COMBO::gui_draw (int nof, SSTRINGS &)
{
	guisendprompt();
	if (readonly){
		diagui_send_Label (buf);
		#if 0
			char tmp[1000];
			diagui_sendcmd (P_String,"S%d %d %s\n",nof,fwidth,diagui_quote(buf,tmp));
		#endif
	}else if (listvalueonly){
		char tmp[1000];
		diagui_sendcmd (P_Choice,"C%d %s\n",nof,diagui_quote(buf,tmp));
		int n = opts->getnb();
		for (int i=0; i<n; i++){
			ELM_STR *elm = opts->getitem(i);
			char tmp1[1000],tmp2[1000];
			diagui_sendcmd (P_Choice_item,"\"\" I%d %s %s\n",i
				,diagui_quote(elm->shown,tmp1)
				,diagui_quote(elm->verbose,tmp2));
		}
		diagui_sendcmd (P_End,"\n");
	}else{
		char tmp[1000];
		diagui_sendcmd (P_Combo,"C%d %d %s\n",nof,fwidth
			,diagui_quote(buf,tmp));
		int n = opts->getnb();
		for (int i=0; i<n; i++){
			ELM_STR *elm = opts->getitem(i);
			char tmp1[1000],tmp2[1000];
			diagui_sendcmd (P_Combo_item,"\"\" I%d %s %s\n",i
				,diagui_quote(elm->shown,tmp1)
				,diagui_quote(elm->verbose,tmp2));
		}
		diagui_sendcmd (P_End,"\n");
	}
}
PUBLIC MENU_STATUS FIELD_COMBO::gui_get(int nof, const char *, const char *)
{
	strcpy_cut (buf,diagui_getval('C',nof),size);
	return MENU_NULL;
}

/*
	Get the letter use to define the ID of a field in GUI mode.
*/
PUBLIC char FIELD_COMBO::getidprefix ()
{
	return 'C';
}

PUBLIC int FIELD_COMBO::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	const char *old_val = html_getoldval (key);
	const char *new_val = html_getval (key);
	char sel_key[100];
	sprintf (sel_key,"SELECT_%s",key);
	int sel_val = atoi(html_getval (sel_key));
	// fprintf (stderr,"validate combo %s val :%s: old :%s: buf :%s: sel_val %d\n",key,new_val,old_val,buf,sel_val);
	if (strcmp(buf,old_val)==0){
		if (sel_val != 0 || listvalueonly){
			strcpy (buf,opts->getshown(sel_val-1));
		}else{
			strcpy_cut (buf,new_val,size);
		}
		ret = 0;
	}
	return ret;
}

/*
	Add a combo field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.
*/
PUBLIC FIELD_COMBO *DIALOG::newf_combo(
	const char *prompt,
	SSTRING &str,
	int maxsiz)
{
	FIELD_COMBO *s = new FIELD_COMBO(prompt,str,maxsiz);
	add (s);
	return s;
}

PUBLIC FIELD_COMBO *DIALOG::newf_combo(
	const char *prompt,
	SSTRING &str)
{
	return newf_combo (prompt,str,30);
}

/*
	Add a selection field to the dialog.
	The object will be destroyed by the dialog itself.
	The object is returned so the caller may add options in the
	pick list.

	Unlike a combo, the user may not enter anything in it. The value
	must be in the list.
*/
PUBLIC FIELD_LIST *DIALOG::newf_list(
	const char *prompt,
	SSTRING &str)
{
	FIELD_LIST *s = new FIELD_LIST (prompt,str);
	add (s);
	return s;
}

PUBLIC VIRTUAL int FIELD_LIST::post_validate()
{
	int ret = -1;
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		// fprintf (stderr,"post_valid %d :%s: :%s:\n",i,buf,opts->getshown(i));
		if (strcmp(buf,opts->getshown(i))==0){
			ret = 0;
			break;
		}
	}
	if (ret == -1){
		xconf_error (MSG_U(E_INLIST,"The value must be taken from the list"));
	}
	return ret;
}

PUBLIC void FIELD_LIST::save()
{
	for (int i=0; i<opts->getnb(); i++){
		ELM_STR *s = opts->getitem(i);
		if (strcmp(buf,s->shown)==0){
			str.setfrom (s->value);
			break;
		}
	}
}


PUBLIC MENU_STATUS FIELD_LIST::dokey (
	WINDOW *dialog,
	int ,
	FIELD_MSG &,
	bool &)
{
	if (!is_readonly()) assist(dialog);
	return MENU_NULL;
}

static SSTRING tmpstr;

/* #Specification: FIELD_ENUM / principle
	A FIELD_ENUM is like a field list, except that the information
	edited is the index (a selector) in the list, while the FIELD_LIST
	edit a string which must have the value of one of the item of the list

	In the FIELD_ENUM, we want to know which elm was choosen.
*/
#
/*
	We do a trick. The contructor for FIELD_LIST need a SSTRING.
	We give a dummy.
	Later when the addopt are done, we will fill the edit buffer
*/
PUBLIC FIELD_ENUM::FIELD_ENUM(
	const char *_prompt,
	int &_sel)
	: FIELD_LIST (_prompt,tmpstr), sel(_sel)
{
	backup_sel = sel;
}

PUBLIC void FIELD_ENUM::restore()
{
	sel = backup_sel;
}
PUBLIC void FIELD_ENUM::reload(const char *dianame, int nof)
{
	const char *s = opts->getshown(sel);
	if (s == NULL) s = "";
	strcpy (buf,s);
	sendval (dianame,nof,'C',s);
}

PUBLIC void FIELD_ENUM::save()
{
	int n = opts->getnb();
	for (int i=0; i<n; i++){
		if (strcmp(buf,opts->getshown(i))==0){
			sel = i;
			break;
		}
	}
}	

PUBLIC void FIELD_ENUM::addopt(const char *str)
{
	if (opts->getnb()==sel){
		strcpy (buf,str);
		backup.setfrom(str);
	}
	FIELD_LIST::addopt(str);
}
/*
	Add one string option to the combo box pick list.
	This time there is two string. The strings will be shown in
	the pick list like this

	value verbose
*/
PUBLIC void FIELD_ENUM::addopt(const char *value, const char *verbose)
{
	FIELD_LIST::addopt(value,verbose);
	if (opts->getnb()==sel+1){
		strcpy (buf,opts->getshown(sel));
		backup.setfrom(buf);
	}
}

/*
	Create a FIELD_ENUM field
*/
PUBLIC FIELD_ENUM *DIALOG::newf_enum(
	const char *prompt,
	int &sel)
{
	FIELD_ENUM *s = new FIELD_ENUM(prompt,sel);
	add (s);
	return s;
}
	
