#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

struct RUNLEVEL {
	char init_runlevel;		// as understood by /sbin/init
	char netconf_runlevel;		// as understood by netconf
					// 0,1 or 2
	char graphic_level;		// 0: text mode
					// 1: Graphic mode, workstation
					// 2: X terminal
	SSTRING title;
	char graphic_err;	// Not available because graphic is
				// not configured
	char net_err;		// Not available because net is
				// not configured
};
struct ASK_PARM{
	char askrun;		// Is askrunlevel active at boot time
	int timeout;		// Timeout on the askrunlevel screen
	int defmode;
	int diatimeout;		// Timeout on dialog when activating
						// configuration and booting
};

class RUNLEVELS{
public:
	RUNLEVEL tbrun[6];
	SSTRING tbmenu[6];
	/*~PROTOBEG~ RUNLEVELS */
public:
	RUNLEVELS (int graphic_ok, int net_ok);
	void config (void);
	void define (void);
	int find_initlevel (int initlevel);
	RUNLEVEL *getfromchoice (int choice);
private:
	void parse (const char *str, RUNLEVEL *ptrun);
public:
	void save (void);
	void setlevel (int choice);
	int setmenu (const char *menuopt[]);
	~RUNLEVELS (void);
	/*~PROTOEND~ RUNLEVELS */
};

#endif
