/***************************************************************************
                          waveinput.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "waveinput.h"

WaveInput::WaveInput(int ptt = -1): Input(ptt)
{
}
WaveInput::~WaveInput(){
}

/** Opens the Device for writting, for Wavefiles this means write nothing ! */
bool WaveInput::open_Device_write(QString Device)
{
return true;
}

/** puts the Samples onto the Device, for a Wavemode Device nothing happens */
int WaveInput::putSamples(double *sample,int anzahl)
{
return anzahl;
}
	
/** Dummy */
void WaveInput::PTT(bool mode)
{
}
/** Dummy */
bool WaveInput::setParams(QString *errorstring)
{
return true;
}

 /** Opens the Device named Device for reading */

bool WaveInput::open_Device_read(QString Device)
{
char header[5];
char c;
QString s;
int i;
fd = open(Device,O_RDONLY);
if (fd < 0)
	return false;
// Check for RIFF
i =read(fd,&header[0],4*sizeof(header[0]));
if ( i != 4)
	{
		close(fd);
		qWarning("Header mismatch\n");
		return false;
	}
header[4]=0;	
s=QString(header);

if  ( s != "RIFF")
	{
		close(fd);
		qWarning(Device + " is not a RIFF File\n");
		return false;
	}
//Check for Wave
lseek(fd,8,SEEK_SET);

i =read(fd,&header[0],4*sizeof(header[0]));
header[4]=0;
if ( i != 4)
	{
		close(fd);
		qWarning("SubType mismatch\n");
		return false;
	}
s=QString(header);

if  ( s != "WAVE")
	{
		close(fd);
		qWarning(Device + " is not a WAVE File\n");
		return false;
	}
// Now find data

i=read(fd,&header[0],4*sizeof(header[0]));
if ( i != 4)		
	{
		close(fd);
			qWarning("No data found\n");
	return false;
	}
header[5]=0;

s=QString(header);
while( ( s != "data" ) && (i > 0) )
	{
		i = read (fd,&c,1);
		s.remove(0,1); 	// remove first character
		s += c;					// append new one
	}		
if ( s == "data")
	{		// got it
		offset = lseek(fd,4,SEEK_CUR);		
		lseek(fd,offset,SEEK_SET); //Remove 4 bytes length info
		return true;
	}
else
	{								//no data found
		close(fd);
			qWarning("No data found\n");
	return false;
	}
	
}

int WaveInput::getSamples(double *sample,int anzahl)
{
unsigned char c[2];
int i,j;
j=0;
double x;
while (j<anzahl)
 {

  i= read(fd,&c[0],2*sizeof(c[0]));
  if (i == 2)
  	{
			if ( c[1] < 128 )
			i =  c[0]+ c[1]* 256 ;
			else
			i = ( c[1]- 256) *256 +c[0];
  		x= i;
			*(sample++)= x/8.;
			
			j++;
		}		
   else

		
    lseek(fd,offset,SEEK_SET);
		
 } // End while
return j;

}
