/***************************************************************************
                          parameter.h  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef PARAMETER_H
#define PARAMETER_H

#include <qobject.h>
#include <qapplication.h>
#include <qfont.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>
#include <qcolor.h>
#include "color.h"
#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>

#include "checkcom.h"


/**Contains parameters for transmitting and receiving

some of them are set by settup
  *@author Volker Schroer
  */
//class CSound;

//enum Mode {BPSK,QPSK,CW_MODE,IQPSK,RTTY,MFSK16};
enum Mode {BPSK,QPSK,RTTY,MFSK16};

enum Status
{
TX_END_STATE,				//Xmitting should be stoped
TX_OFF_STATE,				//TX is off, so we are receiving
TX_SENDING_STATE,		//TX is sending text
TX_PAUSED_STATE ,		//TX is paused
TX_PREAMBLE_STATE,	//TX sending starting preamble
TX_POSTAMBLE_STATE,	//TX sending ending posteamble
TX_CWID_STATE,			//TX sending CW ID
TX_TUNE_STATE			//TX is tuning mode
};

class Parameter : public QObject
	{
   Q_OBJECT
public: 
	Parameter();
	~Parameter();

// Variables

/** MinimumWindowWidth */
int MinimumWindowWidth;
/** MinimumWindowHeight */
int MinimumWindowHeight;
/** Height of Statusbar */
int StatusBarHeight;

/** Userdefinable Font for the Labels in Rx Window */
QFont RxLabelFont;
/** Userdefinable Font for the text in RxWindow*/
QFont	RxWindowTextFont;
/** Userdefinable Font for the Labels in TxWindow*/
QFont TxLabelFont;
/** Userdefinable Font for the text in TxWindow */
QFont TxWindowTextFont;
/** Font for Panel Labels*/
QFont PanelLabelFont;

bool net;								// Connect RX- Frequency to TX - Frequency ?
QColor colours[4];			// Colours to recognize the different RX- Windows


Status status;					// Status
QString callsign;				// Callsign

QString theircall;			// Callsign of remote Op
QString Name; 					// Name of remote Op

QString inputFilename;	//Name of Demofile
QString DemoModeFileType[3]; // File Type of DemoFile
int DemoTypeNumber;				// Index of selected FileType
//int SampleSource;				// Filedescriptor for input File
int serial; 						// Filedescriptor for serial Device for PTT
bool DemoMode;					// DemoMode ?

int ptt;								// Number of ComPort for PTT 0=none 1-4 Number of ComPort
int timeoffset;					// offset to UTC
int clockerror;
QString CWIdString;     // CWIdString  = de CALLSIGN
bool NeedCWid;

QString Macro0;
QString Macro1;
QString Macro2;
QString Macro3;

QString StationFile;
QString ButtonName;
QString ButtonFile;
/** Number of Input Device
		1 = Mic
		2 = Line
		*/
int InputSource; 				
int InputVolume;				//Input Volume off Mic
int OutputVolume;				//OutputVolume (line)

bool slashed0; 				// True if to print 0 slashed

int RxChannels;
int actChannel;

Mode DemodulatorType[4];


public slots:
//void afc(bool);
void usenet(bool);
void setTheirCall(const QString &call);
void setName(const QString &name);
};

#endif
