/***************************************************************************
                          linpsk.cpp  -  description
                             -------------------
    begin                : Sat Mar  4 22:29:25 /etc/localtime 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : huv.schroer@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "linpsk.h"

LinPskApp::LinPskApp()
{


  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts

  initView();

  initMenuBar();
  SaveText="";
  statusTime=new QTimer(this);
  connect( statusTime, SIGNAL(timeout()),this, SLOT(restoreStatusLine()) );
	
	setMaximumSize(800,680);
  view->setMinimumSize(settings.MinimumWindowWidth,settings.MinimumWindowHeight);
}

LinPskApp::~LinPskApp()
{
}

void LinPskApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu

  fileMenu=new QPopupMenu();
	//Open DemoFile
  fileMenu->insertItem("&Open DemoFile ...", this, SLOT(slotFileOpen()), CTRL+Key_O, ID_FILE_OPEN);
  fileMenu->insertSeparator();
  //Quit
  fileMenu->insertItem("E&xit", this, SLOT(slotFileQuit()), CTRL+Key_Q, ID_FILE_QUIT);


  //////////////////////////////////////////////////////////////////
	// Setup Menu
	/////////////////////////////////////////////////////////////////
	settingsMenu=new QPopupMenu();
	// Settings

	settingsMenu->insertItem("Settings...",this,SLOT(slotSetup()),0,ID_SETTINGS_SETUP);
	// Fonts
	settingsMenu->insertItem("Font Settings...",this,SLOT(slotFontSetup()),0,ID_SETTINGS_FONT_SETUP);
	// Colors
	settingsMenu->insertItem("Color Settings...",this,SLOT(slotColorSetup()),0,ID_SETTINGS_COLOR_SETTINGS);
	// Edit Macros
	settingsMenu->insertItem("Edit Macros",this,SLOT(sloteditMacros()),0,ID_SETTINGS_EDITMACROS);

	settingsMenu->insertSeparator();
	// Save Settings
	settingsMenu->insertItem("Save Settings ",this,SLOT(slotsaveSettings()),0,ID_SETTINGS_SAVESETTINGS);	
  
  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  helpMenu=new QPopupMenu();
  helpMenu->insertItem("About...", this, SLOT(slotHelpAbout()), 0, ID_HELP_ABOUT);


  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar 

  menuBar()->insertItem("&File", fileMenu);
  menuBar()->insertSeparator();
	menuBar()->insertItem("&Settings", settingsMenu);
	menuBar()->insertSeparator();
  menuBar()->insertItem("&Help", helpMenu);
  
  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  connect(settingsMenu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));
  connect(helpMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));
  
}




void LinPskApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here

  view=new LinPskView(this);
	setCentralWidget(view);
	
	connect(view,SIGNAL(abbruch()),this,SLOT(slotFileQuit()));
	connect(this,SIGNAL(ButtonNameChanged()),view->controls,SLOT(NameChanged()));


}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////



void LinPskApp::slotFileOpen()
{
  slotStatusHelpMsg(tr("Opening file..."));

  QString fileName = QFileDialog::getOpenFileName(0,settings.DemoModeFileType[settings.DemoTypeNumber],this);
  if (!fileName.isEmpty())

	settings.inputFilename = fileName;

  else

   slotStatusHelpMsg(tr("Opening aborted"));



}





void LinPskApp::slotFileQuit()
{ 
  slotStatusHelpMsg(tr("Exiting application..."));
    qApp->quit();

 }



void LinPskApp::slotHelpAbout()
{
  QMessageBox::about(this,tr("About..."),
                     IDS_APP_ABOUT );
  setActiveWindow();
}

void LinPskApp::slotStatusHelpMsg(const QString &text)
{	
	if ( statusTime->isActive() )  //Check if timer is running
				
					 statusTime->stop();   // Stop timer
				
		else			
			SaveText=view->msg->text(); // Only save text if timer wasn't active

	statusTime->start(3000,true);
  view->msg->setText( text);


}

void LinPskApp::statusCallback(int id_)
{
  switch (id_)
  {

    case ID_FILE_OPEN:
         slotStatusHelpMsg(tr("Opens an existing document"));
         break;




    case ID_FILE_QUIT:
         slotStatusHelpMsg(tr("Quits the application"));
         break;

		case ID_SETTINGS_SETUP:
				 slotStatusHelpMsg(tr("General Setup..."));
				 break;

		case ID_SETTINGS_FONT_SETUP:
				 slotStatusHelpMsg(tr("Setting up Fonts for the different Windows"));
				 break;
				 				 	
		case ID_SETTINGS_EDITMACROS:		
				 slotStatusHelpMsg(tr("Define/Change Macros..."));
				 break;
				
 		case ID_SETTINGS_SAVESETTINGS:
				 slotStatusHelpMsg(tr("Save Setup and Macros"));
				 break;
				  		
    case ID_HELP_ABOUT:
         slotStatusHelpMsg(tr("Shows an aboutbox"));
         break;
  }
}

void LinPskApp::slotSetup()
{
int flags;
bool ok;
QString c;

Setup *setup = new Setup(this);

setup->move(this->x()+50,this->y()+50);

flags=TIOCM_RTS|TIOCM_DTR;
if (setup->exec() != 0)
	{


	//DemoMode	
	if (settings.DemoMode != setup->demoMode)
		{
			settings.DemoMode=setup->demoMode;
			settings.inputFilename="";
			view->stopAll();			
			if (view->sound != 0)
				{
					delete view->sound;
					view->sound =0;
				}
			}
		settings.DemoTypeNumber=setup->DemoTypeNumber; // Save Demo File Type
		
		settings.InputSource = setup->InputSource;
					

	//UserCallsign
	settings.callsign  = setup->UserCallSign->text();

	// StationFile
	settings.StationFile=setup->SendFile->text();

	// TimeOffset

	c=setup->TimeOffset->text();
	flags = c.toInt(&ok);
	if ( ok)
		settings.timeoffset=flags;

	view->setclock(); // Setting Clock
	//ButtonName
	c= setup->ButtonName->text();
	if ( c != "")
		settings.ButtonName = setup->ButtonName->text();
	else
		settings.ButtonName = "undefined";

	emit ButtonNameChanged();

	settings.ButtonFile = setup->ButtonFile->text();
	// InputVolume
	c=setup->InputLevel->text();
	flags = c.toInt(&ok);
	if (ok)
		if (flags != settings.InputVolume)
					settings.InputVolume=flags;
		
	// OutputVolume

	c=setup->OutputLevel->text();
	flags = c.toInt(&ok);
	if (ok)
		if (flags != settings.OutputVolume)
					settings.OutputVolume=flags;

		
	
	// Slashed Zero
	settings.slashed0 = setup->slashed0;

	// RxChannels
	c=setup->RxChannels->text();
	flags= c.toInt(&ok);
	if (ok)
	 {
	 	if (flags != settings.RxChannels )	
			{
			delete view->tx->SelectRxWindow;
			view->tx->SelectRxWindow = new CRxSelect(flags,view,view->tx,"RXWindow");
			view->tx->SelectRxWindow->setButton(0);
	
			if (flags > settings.RxChannels) // Maximum of RxChannels is checked in the Box
			 																 // We have to construct the new Channels	
					view->initRxChannels(settings.RxChannels,flags);
			 else
			 {															 // We have to delete the unused Channels	
			 for(int i=settings.RxChannels-1;i>=flags;i--)
			 	{
			 		delete view->demodulator[i];
			 		view->demodulator[i]=0;
			 		delete view->rx[i];
			 		view->rx[i]=0;
			 	}

			 }
		
		 	settings.actChannel=0;
		 	settings.RxChannels=flags;
			view->rx[0]->show();
			view->tx->SelectRxWindow->show();
			
			}		
	 }

	if (settings.ptt != setup->ptt)
		{
			settings.ptt =setup->ptt;
			switch (settings.ptt)
				{
					case 1:
						settings.serial=open("/dev/ttyS0",O_RDONLY);
						break;
					case 2:
						settings.serial=open("/dev/ttyS1",O_RDONLY);
						break;
					case 3:
						settings.serial=open("/dev/ttyS2",O_RDONLY);
						break;
					case 4:
						settings.serial=open("/dev/ttyS3",O_RDONLY);
						break;
					default:
						break;
				 }
				if (settings.serial >0)
					 ioctl(settings.serial,TIOCMBIC,&flags);
				}



c="LinPsk Version ";
c +=VERSION;



	if (!settings.DemoMode)
		{
			settings.inputFilename="/dev/audio";
			c += " -- "+settings.callsign;
			if (view->sound == 0 )
				view->sound = new CSound(settings.serial);
		}
	else
    c += " -- DemoMode";
		this->setCaption(c);
			if (view->sound == 0)
			{	
				if (settings.DemoTypeNumber == 1)
					view->sound = new WaveInput(-1);
				else
					view->sound = new TextInput(-1);	
			}		
	}
	
setInputSource(settings.InputSource);
setVolume(settings.InputSource,settings.InputVolume);
setOutputVolume(settings.OutputVolume);
setActiveWindow();
view->repaint(true);
}

void LinPskApp::slotsaveSettings()
{
QFile ConfigFile("LinPsk.config");
QString s;
s=QDir::homeDirPath();
QDir d=QDir::home();
d.setCurrent(s.data());
if ( ConfigFile.open(IO_WriteOnly) )	// File is writable
	{
		s="MinimumWindowWidth=" + s.setNum(settings.MinimumWindowWidth) + "\n";
		ConfigFile.writeBlock(s.data(),s.length());
		s="MinimumWindowHeight=" + s.setNum(settings.MinimumWindowHeight) + "\n";
		ConfigFile.writeBlock(s.data(),s.length());
		s="StatusBarHeight=" + s.setNum(settings.StatusBarHeight) + "\n";
		ConfigFile.writeBlock(s.data(),s.length());

		s="callsign="+settings.callsign+"\n";  //Callsign
		ConfigFile.writeBlock(s.data(),s.length());
		s.sprintf("ptt=%d\n",settings.ptt);            //ptt
		ConfigFile.writeBlock(s.data(),s.length());
		if(settings.DemoMode)                          //Demomode
			s="DemoMode=true\n";
		else
			s="DemoMode=false\n";
		ConfigFile.writeBlock(s.data(),s.length());			
		
		if (settings.DemoTypeNumber > 0)														//DemoTypeNumber
			{
				s="DemoType=" + s.setNum(settings.DemoTypeNumber) + "\n";
				ConfigFile.writeBlock(s.data(),s.length());
			}	
		if(settings.slashed0)                        //Decoder
			s="SlashedZero=true\n";
		else
			s="SlashedZero=false\n";
		ConfigFile.writeBlock(s.data(),s.length());
                                                      // Macros
    s="Macro0="+settings.Macro0+"\n";	
		ConfigFile.writeBlock(s.data(),s.length());

    s="Macro1="+settings.Macro1+"\n";	
		ConfigFile.writeBlock(s.data(),s.length());

    s="Macro2="+settings.Macro2+"\n";	
		ConfigFile.writeBlock(s.data(),s.length());

    s="Macro3="+settings.Macro3+"\n";	
		ConfigFile.writeBlock(s.data(),s.length());

		s="StationFile="+settings.StationFile+"\n";				// Files
		ConfigFile.writeBlock(s.data(),s.length());

		s="ButtonName="+settings.ButtonName+"\n";
		ConfigFile.writeBlock(s.data(),s.length());

		s="ButtonFile="+settings.ButtonFile+"\n";
		ConfigFile.writeBlock(s.data(),s.length());

		s="TimeOffset="+s.setNum(settings.timeoffset)+"\n";	//Time
		ConfigFile.writeBlock(s.data(),s.length());

		s="InputSource="+s.setNum(settings.InputSource)+"\n";
		ConfigFile.writeBlock(s.data(),s.length());
		s="InputVolume="+s.setNum(settings.InputVolume)+"\n";	//InputVolume
		ConfigFile.writeBlock(s.data(),s.length());

		s="OutputVolume="+s.setNum(settings.OutputVolume)+"\n";	//OutputVolume
		ConfigFile.writeBlock(s.data(),s.length());

		s="Net";
		if (settings.net)
			s +="=true\n";
		else
			s +="=false\n";
 		ConfigFile.writeBlock(s.data(),s.length());					// Net


		s="RxChannels="+s.setNum(settings.RxChannels)+"\n"; //Number of RxChannels
		ConfigFile.writeBlock(s.data(),s.length());
																												//Font Information
		s="RxLabelFont="+settings.RxLabelFont.family()+"\n";
		ConfigFile.writeBlock(s.data(),s.length());	
		s="RxLabelPointSize="+s.setNum(settings.RxLabelFont.pointSize())+"\n";
		ConfigFile.writeBlock(s.data(),s.length());																											

		s="RxWindowTextFont="+settings.RxWindowTextFont.family()+"\n";
		ConfigFile.writeBlock(s.data(),s.length());	
		s="RxWindowTextPointSize="+s.setNum(settings.RxWindowTextFont.pointSize())+"\n";
		ConfigFile.writeBlock(s.data(),s.length());																											
		
		s="TxLabelFont="+settings.TxLabelFont.family()+"\n";
		ConfigFile.writeBlock(s.data(),s.length());	
		s="TxLabelPointSize="+s.setNum(settings.TxLabelFont.pointSize())+"\n";
		ConfigFile.writeBlock(s.data(),s.length());
																													
		s="TxWindowTextFont="+settings.TxWindowTextFont.family()+"\n";
		ConfigFile.writeBlock(s.data(),s.length());	
		s="TxWindowTextPointSize="+s.setNum(settings.TxWindowTextFont.pointSize())+"\n";
		ConfigFile.writeBlock(s.data(),s.length());																											
		
		s="PanelLabelFont="+settings.PanelLabelFont.family()+"\n";
		ConfigFile.writeBlock(s.data(),s.length());																												
		s="PanelLabelPointSize="+s.setNum(settings.PanelLabelFont.pointSize())+"\n";
		ConfigFile.writeBlock(s.data(),s.length());	
																													// Save ColorSettings
		for (int i=0;i < 4;i++)
			{
			int r,g,b;
			long int rgbvalue;
			settings.colours[i].rgb(&r,&g,&b);
			rgbvalue=b+256*g+256*256*r;	
			s="Color"+s.setNum(i)+"="+s.setNum(rgbvalue)+"\n";																																
			ConfigFile.writeBlock(s.data(),s.length());	
			}
						
		ConfigFile.close();
	}
else
	QMessageBox::critical(0,"LinPsk","Could not write LinPsk.config in Directory\n");
}

void LinPskApp::sloteditMacros()
{

editMacro *WMacro = new editMacro(this);

WMacro->move(this->x()+50,this->y()+50);
if ( WMacro->exec() !=  0)
	{
	settings.Macro0 = WMacro->WMacro0->text();
	settings.Macro1 = WMacro->WMacro1->text();
	settings.Macro2 = WMacro->WMacro2->text();
	settings.Macro3 = WMacro->WMacro3->text();


	}
}

void LinPskApp::restoreStatusLine()
{
view->msg->setText(SaveText);
}

/** Setting up the different Fonts  for the windows */
void LinPskApp::slotFontSetup(void)
{
QPopupMenu *FontSetup=new QPopupMenu(this);
FontSetup->insertItem("RxWindow..",this,SLOT(slotRxFontSetup()),0,ID_RX_WINDOW_FONTS);
FontSetup->insertItem("TxWindow..",this,SLOT(slotTxFontSetup()),0,ID_TX_WINDOW_FONTS);
FontSetup->exec(QCursor::pos());

}
/** Selecting RX/TX fonts */

void LinPskApp::slotRxFontSetup()
{
bool ok;
QFont f=QFontDialog::getFont(&ok,settings.RxWindowTextFont,this);
if (ok)
	{
	settings.RxWindowTextFont=f;								//Save Settings
	for(int i=0;i<settings.RxChannels;i++)			//Apply Font
	 view->rx[i]->rxwindow->setFont(settings.RxWindowTextFont);
	}
	
	
}

void LinPskApp::slotTxFontSetup()
{
bool ok;
QFont f=QFontDialog::getFont(&ok,settings.TxWindowTextFont,this);
if (ok)
	{
	settings.TxWindowTextFont=f; // Save Settings
	view->tx->txwindow->setFont(settings.TxWindowTextFont); // Apply Font
	}
}
/** Setup the four different window Colors */
void LinPskApp::slotColorSetup()
{
QPopupMenu *ColorSetup = new QPopupMenu(this);
ColorSetup->insertItem("RxWindow 1",this,SLOT(RxWindowColor0()),0);
if (settings.RxChannels >1)
	ColorSetup->insertItem("RxWindow 2",this,SLOT(RxWindowColor1()),0);

if (settings.RxChannels >2)
	ColorSetup->insertItem("RxWindow 3",this,SLOT(RxWindowColor2()),0);
	
if (settings.RxChannels >3)
	ColorSetup->insertItem("RxWindow 4",this,SLOT(RxWindowColor3()),0);

ColorSetup->exec(QCursor::pos());
ColorSetup->~QPopupMenu();

}
/** Select Color for Window 1 -4 */

void LinPskApp::RxWindowColor0()
{
RxWindowColor(0);
}

void LinPskApp::RxWindowColor1()
{
RxWindowColor(1);
}

void LinPskApp::RxWindowColor2()
{
RxWindowColor(2);
}

void LinPskApp::RxWindowColor3()
{
RxWindowColor(3);
}


void LinPskApp::RxWindowColor(int window)
{
QColor color=QColorDialog::getColor(settings.colours[window],this);
if (color.isValid())
	{
		settings.colours[window]=color;
		view->rx[window]->setColor(color);
		view->tx->SelectRxWindow->setColor(window);
	}	
}
