/***************************************************************************
                          csound.cpp  -  description
                             -------------------
    begin                : Wed Apr 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : huv.schroer@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "csound.h"


CSound::CSound(int ptt = -1):Input(ptt)
{
audioformat=AFMT_S16_LE; // 16 Bit little Endian
//audioformat=AFMT_U8;
mode=0;	//Mono
speed=11025;
fragsize=BUF_SIZE;
started=FALSE;

}
CSound::~CSound()
{
}

bool CSound::setParams(QString *errorstring)
{
unsigned int fs;
int Fragsize;

Fragsize=fragsize;
for (fs=0;Fragsize>0;fs++)
    {
      Fragsize>>=1;
    }

Fragsize=0x7fff0000+fs;

 if(ioctl(fd,SNDCTL_DSP_SETFMT,&audioformat) == -1)
  {
	 *errorstring= QString(QObject::tr("Error setting Audioformat"));
	 return FALSE;
	}
 if(audioformat != AFMT_S16_LE)
	 if(audioformat != AFMT_U8)
  {
		*errorstring = QString(QObject::tr("Device neither supports 16 Bit encoding nor 8 bit unsigned ")) + QString::number(audioformat);
		return FALSE;
	}
if (ioctl(fd,SNDCTL_DSP_STEREO,&mode) == -1)
	{
	 *errorstring=QString(QObject::tr("Error setting Mono Mode"));
   return FALSE;
	}
if (ioctl(fd,SNDCTL_DSP_SPEED,&speed) == -1)
	{
	 *errorstring=QString(QObject::tr("Error setting speed to 11025 HZ"));
	return FALSE;
	}
	// Set Fragsize
  ioctl (fd, SNDCTL_DSP_SETFRAGMENT,&Fragsize);

  // and read it back
  if(ioctl(fd,SNDCTL_DSP_GETBLKSIZE,&fs))
    {
      *errorstring=QString(QObject::tr("Error on reading fragsize"));
      return FALSE;
    }
 if (fs != fragsize*sizeof(short int))
		{
		 *errorstring=QString(QObject::tr("Not enough memory for requested Fragmentsize"));
			return FALSE;
		}
return true;
}

int CSound::getSamples(double *sample,int anzahl)
{

unsigned char audio_buffer[BUF_SIZE*sizeof(short int)];
unsigned char *audiobuffer;

int len;
int i;
short int value;
unsigned short int uvalue;

		audiobuffer=audio_buffer;
 		if (started)
    	 {
				ioctl(fd, SNDCTL_DSP_GETISPACE, &info);
      	if(info.fragments == 0)
	 	  		return 0;
		  	}	
		else
				started= true;
	if (audioformat == AFMT_S16_LE)
	 {	
		len=read(fd,audio_buffer,anzahl*sizeof(short int));
		for(i=0;i<len;i +=2)
  		{
				value = *audiobuffer++ ;
				value = (value & 0x00FF) | ((*audiobuffer++ << 8	) & 0xFF00);		
     		*sample++=float(value);
			}
		 }	
		else
	 {	
		len=read(fd,audio_buffer,anzahl*sizeof(char));
		for(i=0;i<len;i++)
  		{
				uvalue = (*audiobuffer++ << 8	) & 0xFF00;		
     		*sample++=float(uvalue-32786);
			}
		 }	

return len;
}	



bool CSound::open_Device_write(QString Device)
{
		fd=open(Device,O_WRONLY);
		if (fd >= 0)
			return true;
			else
			return false;
}
bool CSound::close_Device()
{
if(fd >= 0)
	close(fd);
fd=-1;
started = false;
return true;
}

int CSound::putSamples(double *sample,int anzahl)
{
 int len;
 int i;

 unsigned char audio_buffer[BUF_SIZE*sizeof(short int)];
 unsigned char *audiobuffer;
 short int value;

 audiobuffer=audio_buffer;	

 ioctl(fd, SNDCTL_DSP_GETOSPACE, &info);
 if(info.fragments <= info.fragstotal-2) // Dont write too much buffers
    {
      return 0;
    }
if (audioformat == AFMT_S16_LE)
	{
	  for (i=0;i<anzahl;i++)
		{
			*sample = *sample/4.;
			value=*sample++;
			*audiobuffer++ = (unsigned char) (value & 0xff);
			*audiobuffer++ = (unsigned char) ((value >> 8) &0xff);
		}
  	len = write(fd,audio_buffer,BUF_SIZE*sizeof(short int));
	}
	else
	{
 		for (i=0;i<anzahl;i++)
		{
			*sample = *sample/2.;
			value = *sample++;
			unsigned short int uvalue = value + 32786;
			*audiobuffer++ =(unsigned char) ((uvalue >> 8) &0xff);
		}
		len = write(fd,audio_buffer,anzahl);
		
	}
  return len;
}

void CSound::PTT(bool mode)
{
int flags;
flags= TIOCM_RTS|TIOCM_DTR;
if (serial <0) // No serial Device selected
		return;
if (mode)		// PTT on
	ioctl(serial,TIOCMBIS,&flags);
else
  ioctl(serial,TIOCMBIC,&flags);
return;
}
