/* LinNeighborhood
 * Copyright (c) 1999-2002 Richard Stemmer and Hans Schmid
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _smbif_h_
#define _smbif_h_


#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <unistd.h>
#include "browsewrap.h"

#define MAXSMBLINEL          200
#define MAXLOGSTRLEN         300
#define GDK_INPUT_READ_      ( GDK_INPUT_READ | GDK_INPUT_EXCEPTION ) 
/* I need GDK_INPUT_EXCEPTION with GTK 1.2 and Kernel 2.2, don't know why */
/* no longer needed for gtk 1.2.2, but leave it in for a while!*/

/* == global (DEBUG) == */
#ifdef DEBUG
FILE *debug_log;
#endif


//Neue Prototypen fuer die _done - Funktionen in browsewrap.h ( ohne '_' )

extern void GetSMBGroups ( char *group_name,
                           char *master_browser,
                           char *user,
                           char *passwd,
                           char *wins_name,
                           char first_master,
                           GROUPS_BROWSE_INFO *browse_info );

extern void GetSMBMachines ( char *group_name,
                             char *master_browser,
                             char *user,
                             char *passwd,
                             char *domain,
                             MACHINES_BROWSE_INFO *browse_info );


extern void GetSMBShares ( char *group_name,
                           char *machine_name,
                           char *domain,
                           char *ipaddr,
                           char *user,
                           char *passwd,
                           SHARES_BROWSE_INFO *browse_info );


extern void LookupByName ( char * machine_name, char * wins_name);
extern void LookupByIP( char *ipaddr);

extern void smbmount(char *servicename, char *mount_point,char *clientname,char *ipaddr,
              char *group_name,char *smbuser,char *smbpasswd,uid_t uid,gid_t gid,
              mode_t filemode,mode_t dirmode,char *supasswd);
extern void smb_mount_memorized(char *mount_point,char ** arglist,char gui_mode);
extern void stop_all_browse ( void );
extern void stop_all_mount ( void );

/*if (supasswd!=NULL) use su-command for mount/umount*/ 
//extern smbmountStateType smbumount(char *mount_point,char *supasswd,char **errstr);
//extern smbmountStateType rootumount(char *mount_point,char *supasswd,char **errstr);
void smbumount(char *mount_point,char *supasswd,char smb,int tag);
extern void init_smbmount(void);


extern int fdread_line_ok(int fd,int *linec,int *linepos,char *linebuf);
extern char *escape_str(char *s,GSList **strlist);
extern void log_execvp_str(const char *path, char *const argv[]);


#endif		/* _smbif_h_ */
