/* $Id: gtkedit.h,v 1.6 2005/03/24 10:27:24 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LING_GTKEDIT_H
#define LING_GTKEDIT_H 1

#include "gtkdefs.h"

#define GTKEDIT_SEARCH_ID "search-id"

enum {
     GTKEDIT_LESSON_NAME,
     GTKEDIT_LESSON_MEANINGS,
     GTKEDIT_LESSON_PERCENT,
     GTKEDIT_LESSON_SOUND,
     GTKEDIT_LESSON_POINTER, /* hidden */
     GTKEDIT_LESSON_EDITED,  /* hidden */
     GTKEDIT_LESSON_COLUMNS
};

enum {
     GTKEDIT_TOOL_NEW,
     GTKEDIT_TOOL_OPEN,
     GTKEDIT_TOOL_SAVE,
     GTKEDIT_TOOL_REFRESH = 4,
     GTKEDIT_TOOL_LAST = 6
};

lingGtkEditor*
gtkedit_init_editor (void);

void
gtkedit_quit_editor (lingGtkEditor *editor);

void
gtkedit_set_toolbar_item_sensitive (lingGtkEditor *editor, int no,
                                    gboolean sensitive);

#endif /* LING_GTKEDIT_H */
