#ifndef _LCS_GLOBAL_VARS
#define _LCS_GLOBAL_VARS

/* some defaults and status-definitions */

#include <time.h>
#include <stdio.h>
#include "lists.h"
#include "../common.h"
#include "../lcp3.h"
#include "srv_def.h"

//#define STAY_TTY

#include <stdio.h>

struct byte_count_t {
    unsigned int sent;
    unsigned int recvd;
    time_t tstamp;
};

struct con_action_t {
//    struct client_t *who;  // who caused the action? may be NULL
    void *who;
    time_t begin;
    char doing;	// see DOING_* in srv_def.h
};    


struct line_t {
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    int dum; // reserved for the list functions
    int id;			// line id
    struct con_action_t con_action;
    int online;			// how many clients are using the con?
    unsigned char con_stat;	// connection - status, CST_*
	unsigned int baud_up;
	unsigned int baud_down;
//    int con_stat;	// connection - status, CST_*
    time_t con_up_time;		// when came the connection up?
    time_t con_up_timeout;	// LCS_CON_UP_TIMEOUT, calling script_esc
	// afterwards...
    time_t con_down_timeout;	// how long do we have to wait for a con down?
    int pinger_ip;
    int pinger_datasize;
    time_t pinger_prev;	// timestamp of previous ping
    time_t pinger_interval;
	// we maintain the directly by scanf parsed byte count and
	// the approximatively calculated (by truncating the last 3
	// decimal digits and dividing by 1.024) kilo bytes count
	// separately.
	// Thats not neccessary: linux has only 32bit byte counters...
	// so they're actually using something like 'unsigned int'
	// on IA32 machines.
	// 20011022: we're counting in bytes, removing all kbyte stuff
	// from the code.
    unsigned int initial_bytes_sent;	// is sometimes not null when con gets up!
    unsigned int initial_bytes_recvd;	// is sometimes not null when con gets up!
    unsigned int bytes_recvd; // -initial.... so we get bytes from this session
    /* for throughput measurements */
    int activity_id;
    struct byte_count_t activity[LCS_ACTIVITY];
    int isdn_channel;
//    char use_isdn;		// if 1, we use /dev/isdninfo for
				// connection status determination.
    int con_type;		// replacement for use_isdn
				// value is CT_*
    char has_locked;		// whether the line has already checked
				// to lock other lines but not released any.
    char allow_manually;	// is CST_UP_USER ok or should it be converted
				// to CST_UP_SERVER?
    char line_locking;		// might lines get locked to CST_LOCKED_UP_CLT?
    char use_isdn_chanop;	// wheter to use the isdn_chanop
    char used_channels;		// how many channels are in use?
    char isdn_id[15];		// which device? (e.g. sport64k )
    char pinger;	// do pings == 1, 0 == don't ping anything.
    char *pinger_hostname;	// hostname instead of ip to ping
    char script_up[256];       // to establish connection
    char script_dn[256];       // to kill connection
    char script_esc[256];      // to escape connection-establishment
    char isdn_channel_op[256]; // to add/remove isdn b-channels
    char con_status_file[256]; // which file represents connection status?
			       // only for con_type == CT_FILE
    char client_online[256];   // gets called with $1 = IP when a client
			       // goes online
    char client_offline[256];  // client_masq reverse --> can be a security
			       // risk!
    char interface[11];        // interface to watch for throughput
			       // (+con_stat for analog connections)
    char isdninfo[256];	       // the location of the isdninfo file of
			       // isdn4linux. Usually /dev/isdninfo
    char linename[LCP3_LINENAME_LEN+1];
};

struct client_t {
    /* first prev, next + id to simulate a list_hdr_t */
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    int ip;         // the clients ip in network byte - order
    short port;     // the port where the client can be accessed (nbo)
    int tcp_sock;   // if it's a LCC, the appropriate socket
    short type;	    // either dialcontrol or linecontrol; LCS_CLT_*
    short status;
	char getall;	// 1/0: if 1, client wants status of any line
	// status of client (online, regged, ...), set from srv!
//    int line_id;    // if clt is online: on which line
		    // a clt can only be on one line at the same time
    struct line_t *line;
    time_t timeout;
	/* time in secs of next refresh since
	   00:00:00 UTC, January 1, 1970 (see Linux 'man 2 time'                        // if the actual time is > than this one, this client
	   will be considered as crashed and kicked out of
	   the 'cltlist' if this time is over.
	   this time will be renewed with each
	   successful command */
    time_t interval;
	/* timeout interval for this client;
	   minimum is LCC_MIN_TIMEOUT
	   maximum is LCC_MAX_TIMEOUT
	   default is LCC_DEFAULT_TIMEOUT
	 */
    time_t started;
	/* when did it go online? -> to calculate online-time! */
    time_t enckey_timestamp;
    time_t enckey_len;
    struct p_order_t pack;	// for tcp connections, partial packets
    int received;	// how much data is stored in pack?
//    char enckey[LCP3_MAX_ENCKEY_LEN+1];
    char name[LCP3_MAX_NAME_LEN+1];
    char *passwd;
};

struct server_t {
    unsigned int bind_to;
    unsigned short port;	// tcp + udp
    int tcp_socket;
    int udp_socket;
    time_t big_loop;
	/* when did we run the big loop the last time? */
    time_t mid_loop;		// when the middle-loop (proc_throughput)?
    time_t small_loop;		// when did we run the small loop the
	// last time? -> to avoid kicks, etc. upon time-corrections
    time_t big_loop_min;
	/* don't do the big loop more than once in this time - interval
	   defaults to LCS_BIG_LOOP */
    char send_throughput;
    char use_user_accounting;	// default is yes=1
    char fast_loop;		// if !=0, the main loop is done more often.
    char ipl_type;	// IPL_INVALID, IPL_ALLOW or IPL_DENY
    char shtdn_ipl_type; // IPL_* for shutdown-ip-list
    FILE *logfile;		// logfile handle
    char logfile_name[256];	// file to log con/client times to.
    char addressbook_location[255];// location of the addressbook

    char script_shutdown[256]; // to shutdown server, needs SHUTDOWN_OK defined to work
    char passwd_file[256];	// /etc/passwd or /etc/shadow like file
    int lpt_status;		// do we use the LPT-status feature? how?
    int lpt_addr;		// which port?
    char lpt_linename[LCP3_LINENAME_LEN+1]; // which line to monitor on lpt-port
	char syslog_call_from;  // parse syslog for 'call from' and get isdn number from there
    int caller_nr_pos;	       // position of the caller phone number
			       // in the ILABEL-line in /etc/isdn/isdn.conf
    int receiver_nr_pos;       // position of the reciever phone number	
	                       // in the ILABEL-line in /etc/isdn/isdn.conf
    char caller_delimiter[255];// a word which only appears in ILABEL line
                               // in /etc/isdn/isdn.conf
    char receiver_delimiter[255];// a word which only appears in the OLABEL line
			       // in /etc/isdn/isdn.conf
    int month_pos;	       // position of the month-string
			       // in /etc/isdn/isdn.conf
    int day_pos;	       // position of the day-string
			       // in /etc/isdn/isdn.conf
    int time_pos;	       // position of the time-string
			       // in /etc/isdn/isdn.conf
    char *html_status_pipe;    // which pipe ("mknod <name> p") to use to
			       // dump our status in html format
    char *pidfile;	       // dump our pid in this file
};

struct ordq_item_t {
    /* first prev, next, id; to simulate a list_hdr_t */
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    struct client_t *who;// new!! xch ip|who
    int ip;		// the clients ip in network byte - order
    unsigned short cmd;
    char msg[LC_MAX_MSG_LEN+1];
    int len;
};

struct ackq_item_t {
    /* first prev, next, id; to simulate a list_hdr_t */
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    struct client_t *who;// new!! xch ip|who
    int ip;		// the clients ip in network byte - order
    time_t prev_try;	// timestamp of previous try
    short cnt;		// if 0, kill entry. cnt-- on eatch sent cmd
    short cmd;
    char msg[LC_MAX_MSG_LEN+1];
    int len;
};

struct ipl_item_t {
    /* first prev, next, id; to simulate a list_hdr_t */
    struct list_hdr_t *prev;
    struct list_hdr_t *next;
    int ip;	// the clients ip in network byte - order (list compatibility)
    int ipa;	// an ip
    int ipb;	// up to this ip or this mask
    char type;	// IPL_MASK or IPL_RANGE
};


/* server - settings */
extern struct server_t *server;

/* the lists cltlist, ordq, ackq, ipl */
extern struct list_anchor_t cltlist;
extern struct list_anchor_t ordq;
extern struct list_anchor_t ackq;
extern struct list_anchor_t ipl;
extern struct list_anchor_t shtdn_ipl;

/* multiline support */
extern struct list_anchor_t lstlines; // items: struct line_t

/* segfault tracking */
extern int segf_indicator;

#endif /* _LCS_GLOBAL_VARS */
