#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "lists.h"
#include "../lcp3.h"
#include <errno.h>
#include "../server/srv_def.h"
extern int h_errno;

typedef struct DATA_COUNT
{
	// used for new data counting
	int GBytes;
	int MBytes;
	int KBytes;
	int Bytes;
} DATA_COUNT;

struct list_anchor_t lstname;
struct list_anchor_t lstline;

struct t_name {
    struct list_item_t* prev;
    struct list_item_t* next;
    int id;
	// end of item header
    
    // used for new data counting
    // for lines opened by server
    DATA_COUNT server;
	// for lines opened manually
    DATA_COUNT manual;
	// end of new data counting

    int secs;
    int mansecs; // for lines: manually
    char name[LCP3_MAX_NAME_LEN+1];
};


struct t_name* get_name(struct list_anchor_t* lst, char *name);
void print_err_begin();
void print_err_end();
void print_html();
void dump();
void sort_names(struct list_anchor_t* lst);

// ---MAIN---------------------------

int main(int argc, char **argv)
{
    FILE* flccfg;
    FILE* flclog;
    int res, lines = 0;
	struct timeval beg, end;
	struct timezone tzone;
    char line[1030];
    char dum[100];
    char d1[4], d2[3], d3[9], d4[5];
    char nlclog[255];
    char month[4] = "";
    char newmonth[4] = "";
    char entrytype[11] = "";
    char isauto;
    char ismanu;
    int newsecs;
    long int bytes;
    char newname[LCP3_MAX_NAME_LEN+1];
    struct t_name* name;
	// used for new data counting
	DATA_COUNT temp_data;
	tzone.tz_minuteswest = 0;
	tzone.tz_dsttime = 0;
	// end of new data counting

    //-----------------------------------------
    list_init(&lstname);
    //------- open lcs config file
    if ( !(flccfg = fopen(getenv("QUERY_STRING"), "r")) )
    {
	if ( !(flccfg = fopen("/etc/linesrv.conf", "r")) )
	{
	    print_err_begin();
	    printf("<p>No LineControl Server configuration file found!</p>\n");
	    print_err_end();
	    exit(-1);
	}
    }
//    while ( ((res = fscanf(flccfg, "logfile %254s", nlclog)) != EOF) && (!res) ) {}
    res = 0;
    while ( fgets(line, sizeof(line), flccfg) )
    {
	sscanf(line, "%s %s", dum, nlclog);
	if ( !strcmp(dum, "logfile") ) { res++; break; }
    }
    fclose(flccfg);
    if ( !res )
    {
	print_err_begin();
	printf("<p>Unable to get logfile name from LineControl Server configuration file!</p>\n");
	print_err_end();
	exit(-1);
    }
    if ( !(flclog = fopen(nlclog, "r")) )
    {
	print_err_begin();
	printf("<p>Unable to open logfile &quot;%s&quot;</p>\n", nlclog);
	print_err_end();
	exit(-1);
    }
    print_html();
    printf("<center><p><a href=\"http://homepage.swissonline.ch/allenfuchs/stefan/lc/\">\
<img src=\"/lclog/lc-logo-01.gif\" width=\"246\" height=\"53\" border=\"0\"></a></p>\n");
    printf("<p>using <font color=\"#333333\">%s</font></p>\n", nlclog);
	gettimeofday(&beg, &tzone);
    while ( fgets(line, sizeof(line), flccfg) )
    {
		lines++;
	sscanf(line, "%10s %s '%*s %*s %*d %*s %*d' '%3s %3s %2s %8s %4s' %d",
		entrytype, newname, d1, newmonth, d2, d3, d4, &newsecs);
	if ( strcasecmp(newmonth, month) )
	{
	    if ( month[0] )
	    {
			dump();
	    }
	    else
	    {
			printf("<p>date of first entry: <font color=\"#333333\">%s %s %s %s %s</font></p>\n",
					d1, newmonth, d2, d3, d4);
			printf("<table align=\"center\" cellspacing=\"1\" cellpadding=\"2\">\n");
			printf("<tr bgcolor=\"#eeeeff\"><td><i>name or IP</i></td><td><i>time hms</i></td><td><i>time sec</i></td><td colspan=\"2\">%% of client sec</td><td align=\"center\">GB</td><td align=\"center\">MB</td><td align=\"center\">KB</td></tr>\n");
	    }
	    strcpy(month, newmonth);
	    printf("<tr><td bgcolor=\"#ffffff\" colspan=\"8\" height=\"4\" align=\"center\"><img src=\"/lclog/hr01.gif\" width=\"460\" height=\"2\"></td></tr>\n");
	    printf("<tr><td bgcolor=\"#eeeeff\" colspan=\"8\"><b>%s %s</b></td></tr>\n", month, d4);
	}
	isauto = 0;
	ismanu = 0;
	if ( !strcmp(entrytype, "user:") )
	{ // handle a user entry
	    if ( !(name = get_name(&lstname, newname)) )
	    {
		name = (struct t_name*)list_add(&lstname, sizeof(struct t_name));
		strcpy(name->name, newname);
		name->secs = newsecs;
	    }
	    else
	    {
		name->secs += newsecs;
	    }
	}
	else
	{
	    isauto = !strcmp(entrytype, "line:");
	    ismanu = !strcmp(entrytype, "manually:");
	}
	if ( isauto || ismanu )
	{ // handle a line/manually entry
	    if ( !(name = get_name(&lstline, newname)) )
	    {
			name = (struct t_name*)list_add(&lstline, sizeof(struct t_name));
			strcpy(name->name, newname);

			name->secs = 0;
			name->mansecs = 0;
	    
			name->server.Bytes = 0;
			name->server.KBytes = 0;
			name->server.MBytes = 0;
			name->server.GBytes = 0;
		
			name->manual.Bytes = 0;
			name->manual.KBytes = 0;
			name->manual.MBytes = 0;
				name->manual.GBytes = 0;
			}
	    	if ( isauto ) name->secs += newsecs;
	    	else if ( ismanu ) name->mansecs += newsecs;
	    	if ( sscanf(line, "%*s %*s '%*s %*s %*d %*s %*d' '%*s %*s %*d %*s %*d' %*d %ld",
				 &bytes) == 1 )
	    	{
				if ( isauto ) 
				{
					// thanks for implementing the K/M/G
					// split. But next time: I think it should
					// be possible to do it without temp_data...
					// I'll change that when I've got the time
					// as it's not that important ;)
					temp_data.Bytes  = name->server.Bytes;
					temp_data.KBytes = name->server.KBytes;
					temp_data.MBytes = name->server.MBytes;
					temp_data.GBytes = name->server.GBytes;

					temp_data.Bytes += bytes;

					while ((temp_data.Bytes/1024) >= 1)
					{
						temp_data.KBytes++;
						temp_data.Bytes -= 1024;
					}

					while ((temp_data.KBytes/1024) >= 1)
					{
						temp_data.MBytes++;
						temp_data.KBytes -= 1024;
					}

					while ((temp_data.MBytes/1024) >= 1)
					{
						temp_data.GBytes++;
						temp_data.MBytes -= 1024;
					}
					
					name->server.GBytes = temp_data.GBytes;
					name->server.MBytes = temp_data.MBytes;
					name->server.KBytes = temp_data.KBytes;
					name->server.Bytes  = temp_data.Bytes;
				}
				else if ( ismanu )
				{
					temp_data.Bytes  = name->manual.Bytes;
					temp_data.KBytes = name->manual.KBytes;
					temp_data.MBytes = name->manual.MBytes;
					temp_data.GBytes = name->manual.GBytes;

					temp_data.Bytes += bytes;

					while ((temp_data.Bytes/1024) >= 1)
					{
						temp_data.KBytes++;
						temp_data.Bytes -= 1024;
					}

					while ((temp_data.KBytes/1024) >= 1)
					{
						temp_data.MBytes++;
						temp_data.KBytes -= 1024;
					}

					while ((temp_data.MBytes/1024) >= 1)
					{
						temp_data.GBytes++;
						temp_data.MBytes -= 1024;
					}
				
					name->manual.GBytes = temp_data.GBytes;
					name->manual.MBytes = temp_data.MBytes;
					name->manual.KBytes = temp_data.KBytes;
					name->manual.Bytes  = temp_data.Bytes;
				}
			}
		}
	//	else printf("bad entrytype: '%s'<br>\n", entrytype);
    }
	gettimeofday(&end, &tzone);
    fclose(flclog);
    dump();

	// table footer
    printf("</table>\n\
<p><table bgcolor=\"#ffffff\" align=\"center\">\n\
<tr>\
<td width=\"10\" bgcolor=\"#ffeec0\">&nbsp;</td><td>user</td>\
<td width=\"20\">&nbsp;</td>\n\
<td width=\"10\" bgcolor=\"#ffd0c0\">&nbsp;</td><td>line by server</td>\
<td width=\"20\">&nbsp;</td>\n\
<td width=\"10\" bgcolor=\"#d0e0ff\">&nbsp;</td><td>line manually</td>\n\
</tr>\n\
</table></p>\n\
<p>date of last entry: <font color=\"#333333\">%s %s %s %s %s</font></p>\n\
<p>lclog for <font color=\"#0066ff\">"LCS_NAME" "LCS_VERSION_STR"</font> &copy; 2000 by S. Fuchs</p>\n\
<p><font color=\"#666666\" size=\"-1\">parsed %d lines in %.2f seconds</p>\n\
</center></body></html>\n",
    d1, newmonth, d2, d3, d4, lines,
	(((float)(end.tv_sec - beg.tv_sec))+(((float)(end.tv_usec - beg.tv_usec))*1e-6)));
    exit(0);
}

// ----------------------------------

struct t_name* get_name(struct list_anchor_t* lst, char *name)
{
    struct t_name* ret = (struct t_name*)lst->first;
    while ( ret )
    {
	if ( !strcmp(ret->name, name) ) return(ret);
	ret = (struct t_name*)ret->next;
    }
    return(NULL);
}

void print_err_begin()
{
printf("\
Content-type: text/html\n\n\
<html><body bgcolor=\"#ffffff\" text=\"000080\">\n\
<p><b>ERROR:</b></p>\
");
}

void print_err_end()
{
printf("\
program terminated.\
\n</body></html>\
");
}

void print_html()
{
    printf("\
Content-type: text/html\n\n\
<html><head><style>\
p, table, br { align: center; }\
</style></head><body bgcolor=\"#ffffff\" text=\"000080\">\n\
");
}

const char *make_time(time_t secs)
{
    static char tstr[30+1];
    int size = 30;
    char *idx;
    snprintf(tstr, size, "%d:", (int)(secs / 3600)); // print hours
    secs %= 3600;
    idx = tstr + strlen(tstr);
    if ( secs / 60 < 10 ) { idx[0] = '0'; idx++; } // eventually print 0
    snprintf(idx, size-strlen(tstr), "%d:", (int)(secs / 60)); // print minutes
    secs %= 60;
    idx = tstr + strlen(tstr);
    if ( secs < 10 ) { idx[0] = '0'; idx++; }
    snprintf(idx, size-strlen(tstr), "%d", (int)secs);
    return(tstr);
}

void dump()
{
    float perc;
    int total = 0;
    struct t_name* nm;
    sort_names(&lstname);
    sort_names(&lstline);
    nm = (struct t_name*)lstname.first;
    while ( nm )
    {
		total += nm->secs;
		nm = (struct t_name*)nm->next;
    }
    nm = (struct t_name*)lstname.first;
    while ( nm )
    {
	    perc = nm->secs * 100 / total;
	    printf("<tr><td bgcolor=\"#ffeec0\">%s</td><td bgcolor=\"#c0c0ff\" align=\"right\">%s</td><td bgcolor=\"#c0c0c0\" align=\"right\">%d</td><td bgcolor=\"c0c0c0\" align=\"right\">%.0f</td><td bgcolor=\"c0c0c0\"><img src=\"/lclog/perc-bar-b.png\" width=\"%.0f\" height=\"6\"></td><td bgcolor=\"#eeeeee\" align=\"center\" colspan=\"3\"><font color=\"#666666\">n/a</font></td></tr>\n",
			    nm->name, make_time(nm->secs), nm->secs, perc, perc);
		nm = (struct t_name*)nm->next;
    }
    nm = (struct t_name*)lstline.first;
    while ( nm )
    {
	// server opened info
	if ( nm->secs > 0 )
	{
		printf("<tr><td bgcolor=\"#ffd0c0\">%s</td><td bgcolor=\"#c0c0ff\" align=\"right\">%s</td><td bgcolor=\"#c0c0c0\" align=\"right\">%d</td><td bgcolor=\"c0c0c0\" colspan=\"2\">&nbsp;</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td></tr>\n",
	    nm->name, make_time(nm->secs), nm->secs, nm->server.GBytes, nm->server.MBytes, nm->server.KBytes);
	    strcpy(nm->name, "&nbsp;");
	}
	// manually opened info
	if ( nm->mansecs > 0 )
	{
		printf("<tr><td bgcolor=\"#d0e0ff\">%s</td><td bgcolor=\"#c0c0ff\" align=\"right\">%s</td><td bgcolor=\"#c0c0c0\" align=\"right\">%d</td><td bgcolor=\"c0c0c0\" colspan=\"2\">&nbsp;</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td><td bgcolor=\"#eeeeee\" align=\"right\">%d</td></tr>\n",
	    nm->name, make_time(nm->mansecs), nm->mansecs, nm->manual.GBytes, nm->manual.MBytes, nm->manual.KBytes);
	}
	// next line
	nm = (struct t_name*)nm->next;
    }
    list_flush(&lstname);
    list_flush(&lstline);
}

void exch_name(struct list_anchor_t* lst, struct t_name** a, struct t_name** b)
{
    static struct list_hdr_t x, y;
    void* px;
    x.next = (*a)->next;
    x.prev = (*a)->prev;
    x.id = (*a)->id;
    px = *a;
    y.next = (*b)->next;
    y.prev = (*b)->prev;
    y.id = (*b)->id;
    //
    (*a)->id = (*b)->id;
    (*b)->id = x.id;
    (*b)->prev = x.prev;
    (*a)->next = (*b)->next;
    if ( x.next == *b )
    {
	(*a)->prev = (void*)(*b);
	(*b)->next = (void*)(*a);
    }
    else
    {
	(*a)->prev = y.prev;
	((struct list_hdr_t*)(*a)->prev)->next = *a;
	(*b)->next = x.next;
	((struct list_hdr_t*)(*b)->next)->prev = *b;
    }
    //
    if ( !(y.next) ) lst->last = (struct list_hdr_t*)(*a);
    else ((struct list_hdr_t*)y.next)->prev = (void*)(*a);
    if ( !(x.prev) ) lst->first = (struct list_hdr_t*)(*b);
    else ((struct list_hdr_t*)x.prev)->next = (void*)(*b);
    //
}

void sort_names(struct list_anchor_t* lst)
{
    struct t_name* a = (struct t_name*)lst->first;
    struct t_name* b;
    int x = 0;
    void *px;
    while ( a )
    {
	b = (struct t_name*)a->next;
	while ( b )
	{
	    if ( strcmp(a->name, b->name) > 0 )
	    {
		exch_name(lst, &a, &b);
		x++;
		px = a;
		a = b;
		b = px;
		b = (struct t_name*)a->next;
		continue;
	    }
	    b = (struct t_name*)b->next;
	    if ( (!b) && x )
	    {
		b = (struct t_name*)a->next;
		x = 0;
	    }
	}
	a = (struct t_name*)a->next;
    }
}
