import os, unittest, shutil, tempfile
from linda.funcs import run_external_cmd
from linda.parser.menu import MenuParser
from sets import Set

class MenuParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_menu.tar.gz' % self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_correct(self):
        "Check a menu file parses correctly"
        mp = MenuParser(os.path.join(self.dir, 'gdm'))
        self.assertEqual(len(mp.menu_file), 4)
        exp_fields = Set(('needs', 'section', 'title', 'command', 'icon', \
            'longtitle'))
        for x in range(1, 4):
            self.assertEqual(mp.menu_file[x]['package'], 'gdm')
            self.assertEqual(exp_fields.intersection(mp.menu_file[x]['fields']), exp_fields)
            self.assertEqual(mp.menu_file[x]['fields']['needs'], '"X11"')
            self.assertEqual(mp.menu_file[x]['fields']['section'], \
                '"Apps/System"')
            self.assertEqual(mp.menu_file[x]['fields']['icon'], \
                '"/usr/share/pixmaps/gdm.xpm"')
        self.assertEqual(mp.menu_file[0]['fields']['title'], \
            '"GDM flexiserver"')
        self.assertEqual(mp.menu_file[0]['fields']['command'], \
            '"gdmflexiserver"')
        self.assertEqual(mp.menu_file[0]['fields']['longtitle'], \
            '"New GDM Session"')
        self.assertEqual(mp.menu_file[1]['fields']['title'], \
            '"GDM flexiserver in Xnest"')
        self.assertEqual(mp.menu_file[1]['fields']['command'], \
            '"gdmflexiserver -n"')
        self.assertEqual(mp.menu_file[1]['fields']['longtitle'], \
            '"New GDM Session in Xnest"')
        self.assertEqual(mp.menu_file[2]['fields']['title'], \
            '"GDM Photo Setup"')
        self.assertEqual(mp.menu_file[2]['fields']['command'], \
            '"gdmphotosetup"')
        self.assertEqual(mp.menu_file[2]['fields']['longtitle'], \
            '"Select a photo for GDM"')
        self.assertEqual(mp.menu_file[3]['fields']['title'], \
            '"GDM Setup"')
        self.assertEqual(mp.menu_file[3]['fields']['command'], \
            '"gksu gdmsetup"')
        self.assertEqual(mp.menu_file[3]['fields']['longtitle'], \
            '"GDM Setup"')

    def test_alleyoop(self):
        "Check another menu file parses correctly"
        mp = MenuParser(os.path.join(self.dir, 'alleyoop'))
        self.assertEqual(mp.menu_file[0]['package'], "alleyoop")
        self.assertEqual(mp.menu_file[0]['fields']['needs'], '"X11"')
        self.assertEqual(mp.menu_file[0]['fields']['section'], \
            '"Apps/Programming"')
        self.assertEqual(mp.menu_file[0]['fields']['title'], '"alleyoop"')
        self.assertEqual(mp.menu_file[0]['fields']['command'], \
            '"/usr/bin/alleyoop"')

