/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/PosixThread.h,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/10 22:20:20 $
 *!!	$Revision: 1.2 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	    Tilo Riemer <riemer@lincvs.org>
 *!!	    Falk Brettschneider <gigafalk@yahoo.com>
 *!!	    Wim Delvaux <wim.delvaux@chello.be>
 *!!	    Jose Hernandez <joseh@tesco.net>
 *!!        Helmut Koll <HelmutKoll@web.de>
 *!!	    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#ifndef POSIXTHREAD_H
#define POSIXTHREAD_H


#include "config.h"
#include "ac_system_defs.h"

#include <stdio.h>
#include <pthread.h>
#include <qstring.h>
#include <qstringlist.h>


class PosixMutex
{
public:
	PosixMutex();
	~PosixMutex();

	void lock();
	void unlock();

protected:
	pthread_mutex_t m_mutex;
};


class PosixCondition : public PosixMutex
{
public:
	PosixCondition();
	~PosixCondition();

	void init();
	void signal();
	bool wait(unsigned long timeout = ULONG_MAX);

private:
	pthread_cond_t m_condition;
};


class PosixThread
{
public:
	PosixThread();
	~PosixThread(); 
   
	void start();
	void exit();
	bool finished();
	bool wait(unsigned long timeout = ULONG_MAX);
	virtual void run() = 0;

private:
	static void *runCtrl(PosixThread *pthread);

	bool m_finished;
   
	pthread_t m_thread;
	PosixCondition m_condition;
};


#endif // POSIXTHREAD_H
