/****************************************************************************
**
** $Id: LogDialogImpl.h,v 1.5 2001/10/10 21:13:24 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef LOGDIALOGIMPL_H_20010626
#define LOGDIALOGIMPL_H_20010626

#include "config.h"
#include "ac_system_defs.h"


#include <qlabel.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qmultilineedit.h>

#include "logtree.h"
#include "loglist.h"
#include "LogDialog.h"


class QTabWidget;
class QPalette;


class RevisionInfo
{
public:
    QString rev;
    QString date;
    QString author;
    QString state;
    QString comment;
    QString tagcomment;
};


class TagInfo
{
public:
    QString rev;
    QString tag;
    QString branchpoint;
};


class LogDialogImpl : public LogDialog
{ 
    Q_OBJECT

public:
    LogDialogImpl( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~LogDialogImpl();
    bool parseCvsLog(QString BaseDir, QString name, QString connectMethod);

protected slots:
	void annotateClicked();
	void diffClicked();
	virtual void displayFileRevision (QString rev);
	void revisionSelected(QString,bool);
	void tag1Selected(const char *);
	void tag2Selected(const char *);
	void tagSelected(QString,bool);
	virtual void SelectSelectionAColor();
	virtual void SelectSelectionBColor();

private:

	void SelectSelectionColor (unsigned char selection);
	QString basedir;
	QString fname;
	QList<RevisionInfo> items;
	QList<TagInfo> tags;
	QString selectionA, selectionB;
	QPalette *pColorBtnPalette;
	QString m_connectMethod;
};

#endif // LOGDIALOGIMPL_H_20010626
