/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/DiffDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: riemer $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/08/06 16:40:47 $
 *!!	$Revision: 1.12 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!    Implementation of LinCVS differences dialog.
 *!!
 *!!    Based on code create by Bernd Gehrmann
 *!!    Copyright (C) 1999 Bernd Gehrmann
 *!!    bernd@@physik.hu-berlin.de
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include "DiffDialogImpl.h"
#include "diffview.h"
#include "CmdThread.h"
#include "globals.h"
#include "PixmapCache.h"


/* 
 *  Constructs a DiffDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
DiffDialogImpl::DiffDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : DiffDialog( parent, name, modal, fl )
{
    diff1 = new DiffView (true, false, DiffFrame);
    DiffViewLayout->addWidget (diff1, 1, 0);

    diff2 = new DiffView (true, true, DiffFrame);
    DiffViewLayout->addWidget (diff2, 1, 1);

    diff1->setPartner(diff2);
    diff2->setPartner(diff1);

    QFontMetrics fm(fontMetrics());
    setMinimumSize(fm.width("0123456789")*12, fm.lineSpacing()*30);

    connect (ButtonDiffUp, SIGNAL(clicked()),
	     diff2, SLOT(findPrevDiff()));

    connect (ButtonDiffDown, SIGNAL(clicked()),
	     diff2, SLOT(findNextDiff()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
DiffDialogImpl::~DiffDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


/* 
 * public slot
 */
void DiffDialogImpl::toggleSynchronize(bool b)
{
    diff1->setPartner(b? diff2 : 0);
    diff2->setPartner(b? diff1 : 0);
}

#define SIDEWIDTH 500
#define COLUMNWIDTH ((SIDEWIDTH-3)>>1)
#define DELIMITERWIDTH (SIDEWIDTH-(COLUMNWIDTH<<1))


bool DiffDialogImpl::parseCvsDiff( QString BaseDir, 
	QString name, QString connectMethod, QString revA, QString revB)
{
    QString command;
    int lineno1, lineno2;

    setCaption ("CVS Diff - " + name);
    revlabel1->setText( revA.isEmpty()?
                        QString(tr("Repository"))
                        : tr("Revision ")+revA );
    revlabel2->setText( revB.isEmpty()?
                        QString(tr("Working dir"))
                        : tr("Revision ")+revB );
    
    bool usingRsh = false;
    bool usingSsh = false;
	  
    if( (QString::compare(connectMethod, "ext") == 0)
         || (QString::compare(connectMethod, "") == 0) )
    {//rsh access
       usingRsh = true; 

       QString sideWidth;
       sideWidth.setNum(SIDEWIDTH);
       command = "cd " + BaseDir + " && ";        

       if (cvsRsh.find("ssh") == 0) {
          if (!sshAgentIsRunning) startSshAgent();
          usingSsh = true;
			
          command += "set-ssh-commit-env.sh \"";
          command += "env CVS_RSH=" + cvsRsh + " cvs -Q diff -N -kk --side-by-side -t -W " + sideWidth;
       } else {//rsh
          command += "env CVS_RSH=" + cvsRsh + " cvs -Q diff -N -kk --side-by-side -t -W " + sideWidth;
       }
    }   

    if(!usingRsh) {
       command.setNum(SIDEWIDTH);
       command = "cd " + BaseDir + " && " + "cvs -Q diff -N -kk --side-by-side -t -W " + command;
    }
    
    if (!revA.isEmpty())
	{
	    command += " -r ";
	    command += revA;
	}
    if (!revB.isEmpty())
	{
	    command += " -r ";
	    command += revB;
	}
    command += " ";
    command += name;
    
    if(!usingSsh) command += " 2>&1";
    else command += "\"";

    //execute
    CmdThread * Thread = new CmdThread(command);
    Thread->start();
    Thread->wait();

    long len = Thread->m_outputQueue.count();

    lineno1 = lineno2 = 0;
    QString line;

    // must skip 5 lines
    for( long i = 5; i < len; i ++ ) {
      line = Thread->m_outputQueue[i];

      QString line1 = line.left(COLUMNWIDTH);
      QString line2 = line.mid(COLUMNWIDTH+DELIMITERWIDTH,COLUMNWIDTH);
      QChar ch = line[COLUMNWIDTH+1];
      //      char marker = ch.latin1();
      char marker = ch;
      DiffView::DiffType type = 
                (marker == '|') ? DiffView::Change : 
		 (marker == '<') ? DiffView::Delete : 
		 (marker == '>') ? DiffView::Insert : 
				  DiffView::Unchanged;

      diff1->addLine(line1, 
                     (type != DiffView::Unchanged ) ? DiffView::Neutral : type,
		     (type!=DiffView::Insert) ? ++lineno1 : -1);

      diff2->addLine(line2, type,
		     (type!=DiffView::Delete)? ++lineno2 : -1);
    }

    delete Thread;
	
    return true;
}








