/* 
   Copyright (c) 1991-1999 Thomas T. Wetmore IV

   Permission is hereby granted, free of charge, to any person
   obtaining a copy of this software and associated documentation
   files (the "Software"), to deal in the Software without
   restriction, including without limitation the rights to use, copy,
   modify, merge, publish, distribute, sublicense, and/or sell copies
   of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be
   included in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
   BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
   ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
*/
/* modified 05 Jan 2000 by Paul B. McBride (pmcbride@tiac.net) */
/*=============================================================
 * standard.h -- Define standard macros and types
 * Copyright(c) 1991-95 by T.T. Wetmore IV; all rights reserved
 * pre-SourceForge version information:
 *   3.0.0 - 05 May 94    3.0.2 - 23 Nov 94
 *   3.0.3 - 25 Jun 95
 *===========================================================*/
#ifndef _STANDARD_H
#define _STANDARD_H

#include "sys_inc.h"

#ifdef WIN32

#define LLREADTEXT "rt"
#define LLREADBINARY "rb"
#define LLREADBINARYUPDATE "r+b"
#define LLWRITETEXT "wt"
#define LLWRITEBINARY "wb"
#define LLAPPENDTEXT "at"

#define LLSTRPATHSEPARATOR ";"
#define LLSTRDIRSEPARATOR "\\"
#define LLCHRPATHSEPARATOR ';'
#define LLCHRDIRSEPARATOR '\\'
#else
#define LLREADTEXT "r"
#define LLREADBINARY "r"
#define LLREADBINARYUPDATE "r+"
#define LLWRITETEXT "w"
#define LLWRITEBINARY "w"
#define LLAPPENDTEXT "a"

#define LLSTRPATHSEPARATOR ":"
#define LLSTRDIRSEPARATOR "/"
#define LLCHRPATHSEPARATOR ':'
#define LLCHRDIRSEPARATOR '/'
#endif

#include "mystring.h"

/* Having 'char *' instead of 'unsigned char *' removes about */
/* 1800 compiler warnings.  We still need to investigate *every* */
/* instance where a STRING is dereferenced and the contents acted */
/* upon directly to determine if there are sign problems */
typedef char *STRING;
typedef const char *CNSTRING;
typedef unsigned char uchar;

#ifndef BOOLEAN
#	define BOOLEAN int
#endif
#ifndef TRUE
#       define TRUE 1
#endif
#ifndef FALSE
#       define FALSE 0
#endif
#define INT int 
#define SHORT short
#define LONG long
#define FLOAT double

typedef void *VPTR;
typedef union {
        BOOLEAN b;
        INT     i;
        FLOAT   f;
        VPTR    w;
        /*LONG   l;*/
} UNION;

#define MAXLINELEN 512

#define VPTRSIZE sizeof(VPTR)

/*typedef VPTR (*FUNC)();*/

#ifndef max
#define max(x,y) ((x)>(y)?(x):(y))
#endif

#ifndef min
#define min(x,y) ((x)>(y)?(y):(x))
#endif

#ifndef NULL
#	define NULL 0
#endif

extern BOOLEAN alloclog;
#define stdalloc(l)   __allocate(l, __FILE__, __LINE__)
#define stdfree(p)    __deallocate(p, __FILE__, __LINE__)
#define stdrealloc(p, size) __reallocate(p, size, __FILE__, __LINE__)
#define FATAL()       __fatal(__FILE__, __LINE__, NULL)
#define FATAL2(qq)    __fatal(__FILE__, __LINE__, qq)
#define ASSERT(b)     if(!(b)) __fatal(__FILE__, __LINE__, NULL)
/*
eqstr does exact string compare
no locale, no custom sort, no Finnish option 
Perry, 2001/07/20
*/
#define eqstr(s,t)     (!strcmp((s),(t)))
#define nestr(s,t)     (strcmp((s),(t)))
#define cmpstr(s,t)    (strcmp((s),(t)))
#define cmpstrloc(s,t) (ll_strcmploc((s),(t)))

#define check_cache()   ___check_cache(__LINE__, __FILE__)

/* TRANSLFNC must return stdalloc'd memory
translation function type, used by some higher-level
functions to pass in translations to lower-level functions */
typedef STRING (*TRANSLFNC)(STRING str, INT len);

/* types returned by chartype */
#define WHITE  ' '
#define LETTER 'a'
#define DIGIT  '0'
#define ZERO    0

/* types for lists */
typedef struct lntag *LNODE;
struct lntag {
	VPTR l_element;
	LNODE l_prev;
	LNODE l_next;
};
#define lelement(n) ((n)->l_element)
#define lprev(n) ((n)->l_prev)
#define lnext(n) ((n)->l_next)

typedef struct ltag {
	INT l_type;
	LNODE l_first;
	LNODE l_last;
	INT l_refcnt;
	/* TO DO - would be nice to keep count here */
} *LIST;
#define ltype(l) ((l)->l_type)
#define lfirst(l) ((l)->l_first)
#define llast(l) ((l)->l_last)
#define lrefcnt(l) ((l)->l_refcnt)

#define LISTNOFREE 0
#define LISTDOFREE 1

#define FORLIST(l,e)\
	{\
		LNODE _lnode = l->l_last;\
		VPTR e;\
		while (_lnode) {\
			e = _lnode->l_element;
#define ENDLIST\
			_lnode = _lnode->l_prev;\
		}\
	}

#define ISNULL(k)	(!k || *k == 0)

/*
	ARRSIZE is to make compiler insert size of
		(1) static array (# elements)
		or
		(2) static string (# characters) (will matter if we shift to wchar_t)
	ONLY use this for true arrays & locally sized strings.
	NEVER use this for pointers!
*/
#define ARRSIZE(qq) ((INT)(sizeof(qq)/sizeof(qq[0])))

struct WAREHOUSE_S;
typedef struct WAREHOUSE_S *WAREHOUSE;

/*
 15 bytes 0-terminated YYYYMMDDHHMMSS, GMT
   0 filled DD,HH, and MM
   because ansi hasn't solved the date problem
*/
typedef struct lldate_s {
	char datestr[15];
} LLDATE;

typedef enum { RECORD_ERROR, RECORD_NOT_FOUND, RECORD_SUCCESS } 
	RECORD_STATUS;

/* null implementation of gettext, in preparation */
/* _() is used for normally translated strings */
#define _(String) (String)
/* We can't use _N() for nonstranslated strings (eg "%d") -- TODO */
/* N_() is used for strings needing translation elsewhere, eg static inits */
#define N_(String) (String)
#define textdomain(Domain)
#define bindtextdomain(Package, Directory)


#endif
