/* -*- mode: c++ -*-

  This file is part of the Life library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2008-03-20

  Copyright (C) 2008, 2009 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file vector.cpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2008-03-20
 */
#include <life/lifealg/vector.hpp>

namespace Life
{
template <typename T>
Vector<T>::Vector () :
    M_is_closed(false),
    M_is_initialized(false)
{}


template <typename T>

Vector<T>::Vector ( DataMap const& dm ) :
    M_is_closed(false),
    M_is_initialized(false),
    M_map ( dm )
{}


template <typename T>

Vector<T>::Vector (const size_type n) :
    M_is_closed(false),
    M_is_initialized(false),
    M_map( n, n )
{
    //init(n, n, false);
}



template <typename T>

Vector<T>::Vector (const size_type n,
                   const size_type n_local) :
    M_is_closed(false),
    M_is_initialized(false),
    M_map( n, n_local )

{
    //init(n, n_local, false);
}



template <typename T>

Vector<T>::~Vector ()
{
    clear ();
}



template <typename T>

Vector<T> & Vector<T>::operator= (const T)
{
    //  error();

    return *this;
}


template <typename T>
void
Vector<T>::init (const size_type n,
                 const size_type nl,
                 const bool fast)
{
    M_map=DataMap( n, nl );
}

template <typename T>
void
Vector<T>::init (const size_type n,
                 const bool fast)
{
    this->init( n, n, fast );
}

template <typename T>

Vector<T> & Vector<T>::operator= (const Vector<T>& v )
{
    if ( this != &v )
        {

            M_map = v.map();
            //std::cout << "calling operator=(Vector)\n";
            //Debug() << "calling operator=(Vector)\n";

            for( size_type i = 0; i < this->localSize(); ++i )
                {
                    this->set( i,  v( v.firstLocalIndex() + i ) );
                }
        }
    return *this;
}



template <typename T>

Vector<T> & Vector<T>::operator= (const std::vector<T>& v )
{
    M_map = DataMap( v.size(), 0 );
    return *this;
}



template <typename T>

void Vector<T>::clear ()
{
    M_is_closed      = false;
    M_is_initialized = false;
}





#if 0
// Full specialization of the print() member for complex
// variables.  This must precede the non-specialized
// version, at least according to icc v7.1
template <>

void Vector<Complex>::print(std::ostream& os) const
{
    assert (this->initialized());
    os << "Size\tglobal =  " << this->size()
       << "\t\tlocal =  " << this->local_size() << std::endl;

    // std::complex<>::operator<<() is defined, but use this form
    os << "#\tReal part\t\tImaginary part" << std::endl;
    for (size_type i=this->first_local_index(); i<this->last_local_index(); i++)
        os << i << "\t"
           << (*this)(i).real() << "\t\t"
           << (*this)(i).imag() << std::endl;
}

#endif

template <>
 int
Vector<float>::compare (const Vector<float> &other_vector,
                        const real_type threshold) const
{
    LIFE_ASSERT (this->isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (other_vector.isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (this->firstLocalIndex() == other_vector.firstLocalIndex()).error( "" );
    LIFE_ASSERT (this->lastLocalIndex()  == other_vector.lastLocalIndex()).error( "" );

    int rvalue     = -1;
    size_type i = firstLocalIndex();
    do
        {
            if ( std::abs( (*this)(i) - other_vector(i) ) > threshold )
                rvalue = i;
            else
                i++;
        }
    while (rvalue==-1 && i<lastLocalIndex());

    return rvalue;
}

// Full specialization for double datatypes
template <>
 int
Vector<double>::compare (const Vector<double> &other_vector,
                         const real_type threshold) const
{
    LIFE_ASSERT (this->isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (other_vector.isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (this->firstLocalIndex() == other_vector.firstLocalIndex()).error( "" );
    LIFE_ASSERT (this->lastLocalIndex()  == other_vector.lastLocalIndex()).error( "" );

    int rvalue     = -1;
    size_type i = firstLocalIndex();

    do
        {
            if ( std::abs( (*this)(i) - other_vector(i) ) > threshold )
                rvalue = i;
            else
                i++;
        }
    while (rvalue==-1 && i<lastLocalIndex());

    return rvalue;
}
#if 0
// Full specialization for long double datatypes
template <>
 int
Vector<long double>::compare (const Vector<long double> &other_vector,
                              const real_type threshold) const
{
    LIFE_ASSERT (this->isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (other_vector.isInitialized()).error( "vector not initialized");
    LIFE_ASSERT (this->firstLocalIndex() == other_vector.firstLocalIndex()).error( "" );
    LIFE_ASSERT (this->lastLocalIndex()  == other_vector.lastLocalIndex()).error( "" );

    int rvalue     = -1;
    size_type i = firstLocalIndex();

    do
        {
            if ( std::abs( (*this)(i) - other_vector(i) ) > threshold )
                rvalue = i;
            else
                i++;
        }
    while (rvalue==-1 && i<lastLocalIndex());

    return rvalue;
}
#endif
#if 0

// Full specialization for Complex datatypes
template <>
int
Vector<Complex>::compare (const Vector<Complex> &other_vector,
                          const Real threshold) const
{
    assert (this->initialized());
    assert (other_vector.initialized());
    assert (this->first_local_index() == other_vector.first_local_index());
    assert (this->last_local_index()  == other_vector.last_local_index());

    int rvalue     = -1;
    size_type i = first_local_index();

    do
        {
            if (( std::abs( (*this)(i).real() - other_vector(i).real() ) > threshold ) ||
                ( std::abs( (*this)(i).imag() - other_vector(i).imag() ) > threshold ))
                rvalue = i;
            else
                i++;
        }
    while (rvalue==-1 && i<this->last_local_index());

    return rvalue;
}
#endif


template <typename T>

void Vector<T>::print(std::ostream& os) const
{
    LIFE_ASSERT (this->isInitialized()).error( "vector not initialized" );
    os << "Size\tglobal =  " << this->size()
       << "\t\tlocal =  " << this->localSize() << std::endl;

    os << "#\tValue" << std::endl;
    for (size_type i=this->firstLocalIndex(); i<this->lastLocalIndex(); i++)
        os << i << "\t" << (*this)(i) << std::endl;
}


template class Vector<double>;
//template class Vector<long double>;

}
