/***************************************************************************
                          slot.h  -  description
                             -------------------
    begin                : Sat Jun 23 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __SLOT_H
#define __SLOT_H

/* check the save directory for saved games and add them to the slot list else
setup a new entry: '_index_ <empty>' */
void init_slots( Engine *engine );

/* get the slot names of the saved games and return them as a list;
must be 10 entries */
Text* get_slot_names( Engine *engine );

/* read slot::name and slot::slot_name from file */
void write_slot_name( Save_Slot *slot, FILE *file );

/* read slot::name and slot::slot_name from file */
void read_slot_name( Save_Slot *slot, FILE *file );

/* set slot::name to name and update the slot::slot_name string */
void update_slot_name( Engine *engine, int slot_id, char *name );

/* save game to a slot; filename: lg_slot._index_ */
int save_game( Engine *engine, int slot_id );

/* load game from slot */
int load_game( Engine *engine, int slot_id );

#endif
