/*

File: scr.h
Project: W, Layer2 -- DOS32 application (DJGPP) and WIN32 console application
Started: 27th October, 1998
Descrition:
  Screen and cursor manipulation functions.

*/

#ifndef SCR_H
#define SCR_H

#ifdef WIN32
#define CursorInfo CONSOLE_CURSOR_INFO
#define CharInfo CHAR_INFO
#endif

#ifdef MSDOS
#define CursorInfo WORD
#define CharInfo WORD
#endif

#ifdef UNIX
#include <curses.h>
#define CursorInfo WORD
#define CharInfo chtype
#endif

#ifdef WIN32
#define	PutAttr(p, a)  p->Attributes = a
#define PutChar(p, c)  p->Char.AsciiChar = c
#endif
#ifdef MSDOS
#define	PutAttr(p, a)  *(((BYTE *)p) + 1) = a
#define PutChar(p, c)  *((BYTE *)p) = c
#endif
#ifdef UNIX
#include <curses.h>
extern void _PutChar(chtype *p, char c);
extern void _PutAttr(chtype *p, BYTE attr);
#define PutAttr(p, a)  _PutAttr(p, a)
#define PutChar(p, a)  _PutChar(p, a)
#endif

extern int ScreenHeight;
extern int ScreenWidth;
extern int CurHeight;
extern int CurWidth;

void GetScreenMetrix(void);
int CalcRectSz(int w, int h);
void puttextblock(int x1, int y1, int x2, int y2, void *buf);
void gettextblock(int x1, int y1, int x2, int y2, void *buf);
void WriteXY(const char *s, int x, int y, BYTE attr);
void FlexWriteXY(const char *s, int x, int y, BYTE attr1, BYTE attr2);
void FillXY(char c, BYTE attr, int x, int y, int count);
void HideCursor(void);
void GetCursorInfo(CursorInfo *pInfo);
void RestoreCursor(CursorInfo *pInfo);
void GotoXY(int	x, int y);
void GetCursorXY(int *x, int *y);

BOOLEAN MapPallete(BYTE *pPallete, int nEntries);

BOOLEAN OpenConsole(void);
BOOLEAN CloseConsole(void);

#endif  /* ifndef SCR_H */
