/*

File: kbd.h
Project: W, Layer2 -- DOS32 application (DJGPP) and WIN32 console application
Started: 27th October, 1998
Descrition:
  Keyboard manipulation functions.

*/

/*
Shift state mask constants
*/
#define kbShift      1
#define kbReserved   2
#define kbCtrl       4
#define kbAlt        8
#define kbScroll     16
#define kbNum        32
#define kbCaps       64

/*
Convertion macroses.
A key is universaly presented by a DWORD -- hi WORD is shift state, lo
WORD is KEY code; KEY code on other hand is as follows -- hi BYTE is
keyboard scan code for this key, lo BYTE is ascii code of the key.
*/
#define KEY(state, scan)	(((DWORD)(((DWORD)state) << 16) | (scan << 8)))
#define ASC(key)	((char)(key & 0x000000ff))
#define SH_STATE(key)	((WORD)((key & 0xffff0000l) >> 16))
#define SCANCODE(key)	((BYTE)((key & 0x0000ff00) >> 8))
#define NO_ASC(key)     ((DWORD)(key & 0xffffff00l))
#define NO_SH_STATE(key)	((DWORD)(key & 0x0000ffff))
#define NO_SH_STATE2(state, key)    ((DWORD)(key & ~KEY(state, 0)))

extern BOOLEAN bCtrlReleased;  /* Indicates whether <CTRL> has released */
extern WORD ShiftState;  /* Current Alt, Ctrl and Shifts state */
extern int nTimeElapsed;  /* Local session time elapsed in seconds */

/*
nGlobalH:M:S can be used as a clock, the idea here in 'W' is
in the w.ini file to be stored elapsed time while 'W' is working
When 'W' is started nGlobalH:M:S is loaded with the values from w.ini,
on exit in W.INI is stored current nGlobalH:M:S.
*/
extern int nGlobalHours;  /* Global hours elapsed */
extern int nGlobalMinutes;  /* Global minutes elapsed */
extern int nGlobalSeconds;  /* Global seconds elapsed */

BOOLEAN kbhit(int *pnSleepTime);
DWORD ReadKey(void);
void GetKeyName(DWORD dwKey, char *psKeyName);

extern const char *KeyNames[];  /* Key names definitions -- used by GetKeyName() */

