#!/usr/bin/perl
#
# This install script must be run using perl!
#

foreach (@ARGV) {
  if (m/^--?perl=(.*)$/) { $perlloc=$1; next; }
  if (m/^--?prefix=(.*)$/) {$prefix=$1; next; }
  print STDERR 
	"Usage: <perl> install [--perl=/abs/path ] [--prefix=/dir]\n";
  exit 1;
}

$prefix="/usr/local" if (!defined($prefix));


if (!defined($perlloc)) {
    @L=();
    $L[$#L+1]=$ENV{"PERL5"} if defined($ENV{"PERL5"});
    $L[$#L+1]=$ENV{"PERL"} if defined($ENV{"PERL"});
    $L[$#L+1]="/usr/bin/perl" if -x "/usr/bin/perl";
    $L[$#L+1]="/usr/local/bin/perl" if -x "/usr/local/bin/perl";
    $L[$#L+1]="/usr/bin/perl5" if -x "/usr/bin/perl5";
    $L[$#L+1]="/usr/local/bin/perl5" if -x "/usr/local/bin/perl5";
    foreach (split(':',$ENV{"PATH"})) {
	$L[$#L+1]="$_/perl" if -x "$_/perl";
    }
    foreach (split(':',$ENV{"PATH"})) {
	$L[$#L+1]="$_/perl5" if -x "$_/perl5";
    }

    print ("Searching for perl 5: ");
    foreach (@L) {
	if (`$_ -v`=~m/[Vv]ersion *([0-9])*/) {
            print " $_ (version $1)";
	    if ($1 >= 5) {
		$perlloc=$_;
		last;
	    }
	} else {
	    print " $_ (unknown)";
	}
    }
    print "\n";
		
    if (!defined($perlloc)) {
	print ("I can't find the location of perl5.\n",
		      "Run install.pl with the --perl=path option.\n");
	exit 1;
    }
}

print "Installing perlpp in\n\n\t$prefix/bin/perlpp\n\nwith default perl location of\n\n\t$perlloc.\n\nInstalling perlpp.1 man page in\n\n\t$prefix/man/man1/perlpp.1\n\nType y and return to install perlpp.\n";

$ch=getc STDIN;
if ($ch ne 'y' && $ch ne 'Y') {
    print "Installation aborted.\n";
    exit 1;
}

mkdir ($prefix,0755) if (! -d $prefix);
mkdir ("$prefix/bin",0755) if (! -d "$prefix/bin");
mkdir ("$prefix/man",0755) if (! -d "$prefix/man");
mkdir ("$prefix/man/man1",0755) if (! -d "$prefix/man/man1");

close STDOUT;
$of="$prefix/bin/perlpp";
open (STDOUT,">$of")
    or die "Could not open $of.\n";
do "perlpp.pl";
close STDOUT;
chmod 0755,$of;

close STDOUT;
$of="$prefix/man/man1/perlpp.1";
open (STDOUT,">$of")
    or die "Could not open $of.\n";
do "perlpp.1.pl";
close STDOUT;
chmod 0644,$of;

