#!/bin/bash

# copyright 2002 lmoore@tump.com under the terms of the GNU GPL.

getVersion() { echo easydialog_cmdline 0.1; }

booleanBox() {
    local answer=

    echo "$1"

    while true; do
        read -e -p "    $2 [Y|n] " answer
        [ $? == 0 ] || break
	[ -z "$answer" ] && return 0
	answer=$(echo $answer | tr A-Z a-z)
        case "$answer" in 
            y|yes) return 0;;
            n|no) return 1;;
            *) echo "        not valid \"$answer\", please enter yes or no."
        esac
    done
    return 255
}

msgBox() {
    (echo "$1"; echo; echo "$2") | ${PAGER-more}
    echo
    read -e -p "    please hit enter to continue"
}

inputBox() {
    (echo "$1"; echo; echo "$2") | ${PAGER-more}

    read -e -p "    $3: " || return $?
}

menuBox() {
    local title=$1
    local text=$2
    shift 2
    local -a words
    words=("$@")

    (echo "$title"; echo; echo "$text") | ${PAGER-more}
    
    while true; do
        local answer
        local -i i=0
	while (($i < ${#words[@]})); do
            local item="${words[$i]}"
            local itemtext="${words[$((i+1))]}"
            printf "  %d) %-20s %-30s\n" $(($i/2+1)) "$item" "$itemtext"
            i=$((i+2))
        done | ${PAGER-more}
	i=$((${#words[@]}/2))
	read -e -p "    select an item [1 - $i]: " answer
        [ $? = 0 ] || return 255
        if echo $answer | egrep '^[0-9]+$' > /dev/null && \
                [ $answer -ge 1 -a $answer -le $i ]; then
            REPLY=${words[$((($answer-1)*2))]}
            return 0
        fi
    done
}

_checkRadioDriver() {
    local driver=$1
    local title=$2
    local text=$3
    shift 3
    local -a words
    words=("$@")
    local -i i=0

    (echo "$title"; echo; echo "$text") | ${PAGER-more}
    
    while true; do
        local answer
        local prompt
        local checked
        local checked_visual
        i=0
	while (($i < ${#words[@]})); do
            local index=$((i/3+1))
            local item="${words[$((i++))]}"
            local itemtext="${words[$((i++))]}"
	    local checked_visual=" "
            if [ "${words[$((i++))]}" = "on" ]; then
              checked=$((i/3))
              checked_visual="*"
            fi
            printf "%s %d) %-20s %-30s\n" "$checked_visual" "$index" \
                                          "$item" "$itemtext"
        done | ${PAGER-more}
	i=$((${#words[@]}/3))
       
        prompt="select an item [1 - $i, enter means your finished]: "
	read -e -p "$prompt" answer || return $?
        [ -z "$answer" ] && break

        # if it's a radio list then turn everything off
        # the selected item will get turned back on
        if [ "$driver" = "radio" ]; then        
            i=0
            while (($i < ${#words[@]})); do
                local item="${words[$((i++))]}"
                local itemtext="${words[$((i++))]}"
                words[$((i++))]="off"
            done
        fi

        # flip the status of the selected item
        if echo $answer | egrep '^[0-9]+$' > /dev/null && \
                [ $answer -ge 1 -a $answer -le $i ]; then
            local opposite
            case "${words[$((($answer-1)*3+2))]}" in
                on) opposite=off;;
                off) opposite=on;;
            esac
            words[$(((($answer-1)*3)+2))]=$opposite
        fi
    done
    
    i=0
    REPLY=$(while (($i < ${#words[@]})); do
        local item="${words[$((i++))]}"
        local itemtext="${words[$((i++))]}"
        local status="${words[$((i++))]}"
        [ "$status" = "on" ] && echo $item
    done)

    return 0
}

radioBox() {
    _checkRadioDriver radio "$@"
}

checkBox() {
    _checkRadioDriver check "$@"
}

textBox() {
    (echo $1; cat $2) | ${PAGER-more}
    read -e -p "    please hit enter to continue"
}

passwordBox() {
    echo $1;
    read -e -s -p "$2: "
}
