/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * fhmtautogen.c
 *
 *    This program is used to generate the two files.
 *    If filename is not given, the files are:
 *         fhmtgen.<n>.c
 *         fhmtgenlow.<n>.c
 *    where <n> is the input index.  Otherwise they are:
 *         <filename>.<n>.c
 *         <filename>low.<n>.c
 *    These two files, when compiled, implement hit-miss dwa
 *    operations for all sels generated by selaAddHitMiss().
 *
 *    The library files fhmtgen.1.c and fhmtgenlow.1.c
 *    were made using index = 1.
 */

#include <stdio.h>
#include <stdlib.h>
#include "allheaders.h"

main(int    argc,
     char **argv)
{
char        *filename;
l_int32      index;
SELA        *sela;
static char  mainName[] = "fhmtautogen";

    if (argc != 2 && argc != 3)
	exit(ERROR_INT(" Syntax:  fhmtautogen index, <filename>", mainName, 1));

    index = atoi(argv[1]);
    filename = NULL;
    if (argc == 3)
        filename = argv[2];

    sela = selaAddHitMiss(NULL);
    if (fhmtautogen(sela, index, filename))
	exit(1);

    selaDestroy(&sela);
    exit(0);
}

