//
// The contents of this file are subject to the Mozilla Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License
// at http://www.mozilla.org/MPL/
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
// the License for the specific language governing rights and
// limitations under the License.
//
// This software was developed as part of the legOS project.
//
// Contributor: Pat Welch (legOS@mousebrains.com)

#ifndef _RotationSensor_H_
#define _RotationSensor_H_

#include <c++/Sensor.H>
#include <dsensor.h>

// This is class deals with the rotation sensor
// In addition to the methods specified in Sensor, other methods include:
// on() turns on rotation tracking
// off() turns off rotation tracking
// pos(int position) sets the current absolute position
// pos() returns the current absolute position

class RotationSensor : public Sensor {
public:
  RotationSensor(const Port port, int position = 0)
    : Sensor((Sensor::Port) port, true), 
    rsensor((port == S1) ? ROTATION_1 :
	    (port == S2) ? ROTATION_2 :
	    ROTATION_3)
  { 
    pos(position); 
  }
  void on() const {ds_rotation_on(&sensor);}
  void off() const {ds_rotation_off(&sensor);}
  void pos(int position) const {ds_rotation_set(&sensor, position);}
  int pos() const {return rsensor;}

private:
  volatile int& rsensor;
};

#endif // _RotationSensor_H_
