/*
 * $Id: lc_dis.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_DIS_H
#define __LC_DIS_H

#include <dis-asm.h>
#include <klib.h>
/* include dump architecture dependend header */
#ifdef DUMP_ARCH_ALPHA
# include <lc_dis_alpha.h>
#endif
#ifdef DUMP_ARCH_ARM
# include <lc_dis_arm.h>
#endif
#ifdef DUMP_ARCH_IA64
# include <lc_dis_ia64.h>
#endif
#ifdef DUMP_ARCH_I386
# include <lc_dis_i386.h>
#endif
#ifdef DUMP_ARCH_PPC64
# include <lc_dis_ppc64.h>
#endif
#ifdef DUMP_ARCH_S390
# include <lc_dis_s390.h>
#endif
#ifdef DUMP_ARCH_S390X
# include <lc_dis_s390.h>
#endif

typedef void (*list_instructions_t) (FILE*);
typedef int (*print_instr_t) (kaddr_t, FILE*, int);
typedef kaddr_t (*print_instr_stream_t) (kaddr_t, int, int ,int, FILE*);
typedef void (*dump_instr_t) (kaddr_t, uint64_t, int, FILE*);

syment_t * (*get_func_name) (char *);

typedef struct dis_info_s{
	list_instructions_t list_instructions;
	print_instr_t    print_instr;
	print_instr_stream_t print_instr_stream;
	dump_instr_t     dump_instr;
	int              use_opcode; 
	disassemble_info disinfo;
} dis_info_t;

/* place to keep dump arch dependend stuff for disassembly */
extern dis_info_t dis_info;

#define	LIST_INSTRUCTIONS  dis_info.list_instructions
#define PRINT_INSTR        dis_info.print_instr
#define PRINT_INSTR_STREAM dis_info.print_instr_stream
#define DUMP_INSTR         dis_info.dump_instr
#define USE_OPCODE         dis_info.use_opcode
#define DISINFO            dis_info.disinfo

/*
 * function prototypes
 */

int  dis_fprintf(PTR, const char*, ...);
int  getidmem(bfd_vma, bfd_byte*, unsigned int, struct disassemble_info*);
void dis_printintaddr(bfd_vma, struct disassemble_info*, int);
void dis_printaddr(bfd_vma, struct disassemble_info*);
int  dis_getsym(bfd_vma, struct disassemble_info*);
void set_dis_ofp(FILE*);
int  dis_init(FILE *, int);

#endif /* __LC_DIS_H */
