/*
 * $Id: cmd_report.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

/*
 * report_cmd() -- run the 'report' command.
 */
void
report_cmd(command_t *cmd)
{
	do_report(cmd->flags, cmd->ofp);
}

#define _REPORT_USAGE "[-w outfile]"

/*
 * report_usage() -- Print the usage string for the 'report' command.
 */
void
report_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _REPORT_USAGE);
}

/*
 * report_help() -- Print the help information for the 'report' command.
 */
void
report_help(command_t *cmd)
{
	CMD_HELP(cmd, _REPORT_USAGE,
	"Display a crash dump report. The report contains information about "
	"the system state when the kernel failure occurred.");
}

/*
 * report_parse() -- Parse the command line arguments for 'report'.
 */
int
report_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FALSE|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * report_complete() -- Complete arguments of 'report' command.
 */
char *
report_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	report_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
