#ifndef PIDFILE_H
#define PIDFILE_H

#include <Exception.h>
#include <sys/types.h>

/// Encapsulates the handling of a pid file
/**
 * Pidfile provides all functions required to manage a pidfile.
 * If the pid directory has not been specified, pidfiles are read, written and
 * created in the directory PID_DIR
 */
class Pidfile
{
protected:
	std::string name;
	bool delete_on_exit;

public:
	/// Construct the pidfile manager for (dir or PID_DIR)/<tag>.pid
	Pidfile(const std::string& tag, const std::string& dir = "");

	/// Delete the pidfile if takeover was previously invoked
	~Pidfile();

	/// Read the content of the pid file
	pid_t read() throw (FileException);
	/// Kill the pid contained in the pidfile with signal `sig'.  Returns false
	/// if no corresponding process is running
	bool kill(int sig) throw (SystemException);
	/// Check if the pid contained in the pid_file corresponds to a running process
	bool is_active() throw (FileException);
	/// Write the current pid in the file, and set the file to be deleted on class destruction
	void takeover() throw (FileException);
	/// Write the specified pid in the file, and set the file to be deleted on class destruction
	void takeover(pid_t pid) throw (FileException);
	/// Delete the pidfile
	void remove() throw (FileException);
};

// vim:set ts=4 sw=4:
#endif
