package latexDraw.util;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;


/** 
 * This class defines paths used in LaTeXDraw.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 05/11/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public abstract class LaTeXDrawPath
{
	/** The name of the cache directory */
	public static final String CACHE_DIR = ".cache";//$NON-NLS-1$
	
	/** The name of the cache directory for shared templates */
	public static final String CACHE_SHARED_DIR = ".cacheShared";//$NON-NLS-1$
	
	/** The name of the templates directory */
	public static final String TEMPLATE_DIR = "templates";//$NON-NLS-1$
	
	public static final String PATH_LOCAL_USER = getPathLocalUser();
	public static final String PATH_TEMPLATES_DIR_USER = PATH_LOCAL_USER + File.separator + TEMPLATE_DIR;
	public static final String PATH_PREFERENCES_FILE_OLD   = PATH_LOCAL_USER + File.separator + ".preferences";//$NON-NLS-1$
	public static final String PATH_PREFERENCES_XML_FILE   = PATH_PREFERENCES_FILE_OLD+".xml";//$NON-NLS-1$
	public static final String PATH_CACHE_DIR      	   = PATH_LOCAL_USER + File.separator + CACHE_DIR;
	public static final String PATH_CACHE_SHARE_DIR	   = PATH_LOCAL_USER + File.separator + CACHE_SHARED_DIR;
	public static final String PATH_TEMPLATES_SHARED   = getPathTemplatesShared();
	public static final String PATH_SHARED 			   = getPathShared();
	
	
	private static String getPathLocalUser()
	{
		String os   = System.getProperty("os.name").toLowerCase();//$NON-NLS-1$
		String home = System.getProperty("user.home");//$NON-NLS-1$
		
		if(os.equals("windows vista"))//$NON-NLS-1$
			return home + "\\AppData\\Local\\latexdraw";//$NON-NLS-1$
		else
			if(os.equals("windows xp") || os.contains("win"))//$NON-NLS-1$ //$NON-NLS-2$
				return home + "\\Application Data\\latexdraw";//$NON-NLS-1$
			else
				if(os.equals("mac os x"))//$NON-NLS-1$
					return home + "/Library/Preferences/latexdraw";//$NON-NLS-1$

		return home + "/.latexdraw";//$NON-NLS-1$
	}
	
	
	
	private static String getPathTemplatesShared()
	{
		String path = getPathShared();
		
		if(path==null)
			return null;
		
		return path+File.separator+TEMPLATE_DIR;
	}
	
	
	private static String getPathShared()
	{
		String os   = System.getProperty("os.name").toLowerCase();//$NON-NLS-1$
		String home = System.getProperty("user.home");//$NON-NLS-1$
		
		if(os.equals("mac os x"))//$NON-NLS-1$
			return "/Users/Shared/latexdraw";//$NON-NLS-1$
		else
			if(os.equals("windows vista"))//$NON-NLS-1$
			{
				File dir = new File("C:\\ProgramData");//$NON-NLS-1$
				int cpt = 0, max = 10;
				
				while(!dir.exists() && cpt<max)
					dir = new File((char)('C'+cpt++)+":\\ProgramData");//$NON-NLS-1$
				
				if(dir.exists())
					return dir.getPath()+"\\latexdraw";//$NON-NLS-1$
				
				dir = new File(home.substring(0, 1+home.lastIndexOf('\\'))+"All Users\\Application Data");//$NON-NLS-1$
				dir.mkdir();
				
				return dir.getPath()+"\\latexdraw";//$NON-NLS-1$
			}
		else
			if(os.contains("win"))//$NON-NLS-1$
			{
				File dir = new File(home.substring(0, 1+home.lastIndexOf('\\'))+"All Users\\Application Data");//$NON-NLS-1$
				dir.mkdir();
				
				return dir.getPath()+"\\latexdraw";//$NON-NLS-1$
			}

		return "/usr/share/latexdraw";//$NON-NLS-1$
	}
	
	
	
	/**
	 * Creates the necessary directories for the installation of LaTeXDraw.
	 * @since 1.9.2
	 */
	public static void checkInstallDirectories()
	{
		try
		{
			(new File(PATH_SHARED)).mkdir();
			(new File(PATH_TEMPLATES_SHARED)).mkdir();
		}
		catch(Exception e) { e.printStackTrace(); }
	}
	
	
	/**
	 * Creates the necessary directories for the execution of LaTeXDraw.
	 * @since 1.9.2
	 */
	public static void checkDirectories()
	{
		try
		{
			(new File(PATH_LOCAL_USER)).mkdir();
			(new File(PATH_TEMPLATES_DIR_USER)).mkdir();
			(new File(PATH_CACHE_DIR)).mkdir();
			(new File(PATH_CACHE_SHARE_DIR)).mkdir();
		}
		catch(Exception e) { e.printStackTrace(); }
	}

	
	
	/**
	 * Allows to get the path of the project where the class LaTeXDrawPath is located.
	 * @return The path or null.
	 * @since 1.9.2
	 */
	public static String getPathJar()
	{
		try
		{
			String path = LaTeXDrawPath.class.getSimpleName() + ".class";//$NON-NLS-1$
		    URL url = LaTeXDrawPath.class.getResource(path);
		    path = URLDecoder.decode(url.toString(), "UTF-8");//$NON-NLS-1$
		    int index = path.lastIndexOf('/');
		    path = path.substring(0, index);
		    String jar = "jar:file:", file = "file:";//$NON-NLS-1$//$NON-NLS-2$
	
		    if(path.startsWith(jar))
		    {
		    	index = path.lastIndexOf("!");//$NON-NLS-1$
		    	path = path.substring(jar.length(), path.substring(0, index).lastIndexOf('/'));
		    }
		    else
		    {
		    	path = path.substring(file.length(), path.length());
		    	Package pack = LaTeXDrawPath.class.getPackage();
		    	
		    	if(null != pack)
		    	{
		    		String packPath = pack.getName().replace('.', '/');
		    		
		    		if(path.endsWith(packPath))
		    			path = path.substring(0, (path.length() - packPath.length()));
		      }
		    }
		   
		    return path;
		    
		}catch(Exception e)
		{
			return null;
		}
	}
}
