package junit.test.svg;

import latexDraw.parsers.svg.SVGComment;
import latexDraw.parsers.svg.SVGDocument;

import org.junit.Test;
import org.w3c.dom.Node;

/** 
 * This class contains tests for the SVGComment class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/31/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGComment extends TestSVGText
{
	@Override
	@Test
	public void testGetNodeType()
	{
		SVGComment cdata = createSVGText("test", doc);
		assertEquals(Node.COMMENT_NODE, cdata.getNodeType());
	}
	
	
	@Override
	protected SVGComment createSVGText(String txt, SVGDocument document) throws IllegalArgumentException
	{
		return new SVGComment(txt, document);
	}
}
