/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "slidinglabel.h"

#include <QPainter>
#include <QPaintEvent>
#include <QTimer>

static const double Acceleration = 0.10;

SlidingLabel::SlidingLabel( QWidget *parent ) : QLabel( parent ),
	m_offset( 0 ),
	m_offsetStep( 0 )
{
	m_switchTimer = new QTimer;
	connect( m_switchTimer, SIGNAL( timeout() ),
	         this, SLOT( slotAnimationFrame() ) );
}

QSize SlidingLabel::sizeHint() const
{
	return QSize( fontMetrics().width( m_text ), height() );
}

void SlidingLabel::setText( const QString &text )
{
	if ( m_text == text ) {
		return;
	}

	m_newText = text;
	if ( m_text.isEmpty() ) {
		m_text = text;
		initScrollingIn();
	} else {
		m_offsetStep = -1.0;
	}
	m_switchTimer->start( 1000 / 25 );
}

void SlidingLabel::mousePressEvent( QMouseEvent * )
{
	emit clicked();
}

void SlidingLabel::paintEvent( QPaintEvent * )
{
    QPainter p( this );
    p.initFrom( this );
    p.eraseRect( rect() );

    const QFontMetrics fm( fontMetrics() );
    p.drawText( m_offset, height() - 4, m_text );
}

void SlidingLabel::slotAnimationFrame()
{
	if ( m_text != m_newText ) {
		m_offset += qRound( m_offsetStep );
		m_offsetStep *= 1 + Acceleration;
		update( textRect() );

		if ( m_offset <= -fontMetrics().width( m_text ) ) {
			m_text = m_newText;
			if ( m_text.isEmpty() ) {
				m_switchTimer->stop();
			} else {
				initScrollingIn();
			}
		}
	} else {
		m_offset += qRound( m_offsetStep );
		m_offsetStep *= 1 - Acceleration;

		if ( m_offset >= 0 ) {
			m_offset = 0;
			m_switchTimer->stop();
		}

		update( textRect() );
	}
}

QRect SlidingLabel::textRect() const
{
	return QRect( 0, 0, fontMetrics().width( m_text ), height() );
}

void SlidingLabel::initScrollingIn()
{
	m_offset = 0;
	m_offsetStep = 1.0;
	while ( m_offset > -fontMetrics().width( m_text ) ) {
		m_offset -= qRound( m_offsetStep );
		m_offsetStep *= 1 + Acceleration;
	}
}

