/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rpwait.c,v 6.3 1999/06/16 05:54:54 jsquyres Exp $
 * 
 *	Function:	- waits for kenya process to die
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *
 *	Accepts:	- ptr to node ID
 *			- ptr to process ID
 *			- ptr to child process status
 *
 *	Returns:	- 0 or ERROR with errno set accordingly
 */

#include <unistd.h>

#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>

int
rpwait(nodeid, pid, status)

int4			*nodeid;
int			*pid;
int			*status;

{
	struct nmsg	nhead;		/* network message descriptor */
	struct preply	reply;		/* kenyad reply */

	nhead.nh_event = (-getpid()) & 0xBFFFFFFF;
	nhead.nh_type = 1;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(struct preply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		return(ERROR);
	}

	*nodeid = ttol(reply.pr_nodeid);
	*pid = (int) ttol(reply.pr_pid);
	*status = (int) ttol(reply.pr_reply);

	return(0);
}
