/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB/RBD
 *
 *	$Log: getnet.c,v $
 *	Revision 6.2  1999/05/26 18:29:02  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:22:51  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:01:03  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:09:59  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:57:22  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:45:49  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.3  94/02/16  16:27:44  gdburns
 * Move getntype() from getnet.c to getnodes.c
 * 
 * Revision 2.2.1.2  93/10/13  17:09:36  gdburns
 * Remove remote replies.
 * Use KSUPER.
 * 
 * Revision 2.2.1.1  93/02/18  17:54:16  gdburns
 * rewrite in absence of getnet()
 * 
 * Revision 2.2  92/04/30  14:49:40  trillium
 * Ohio Release
 * 
 * Revision 2.1.1.2  92/04/27  15:47:49  gdburns
 * Dsend() requires that nmsg be completely filled.
 * 
 * Revision 2.1.1.1  91/06/03  15:08:04  raja
 * Corrected signal masking in ksigblock().
 * 
 * Revision 2.1  91/03/20  11:37:52  gdburns
 * Ohio Release
 * 
 *	Function:	- obtains basic network information
 */

#include <kio.h>
#include <net.h>
#include <rreq.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* kernel interface */

/*
 *	getnodeid
 *
 *	Returns:	- local node identifier
 */
int4
getnodeid()

{
	if (_kio.ki_nodeid == NOTNODEID) {
		getnodes(&_kio.ki_nodeid, 1, NT_ME, NT_ME);
	}

	return(_kio.ki_nodeid);
}

/*
 *	getorigin
 *
 *	Returns:	- origin node identifier
 */
int4
getorigin()

{
	if (_kio.ki_origin == NOTNODEID) {
		getnodes(&_kio.ki_origin, 1, NT_ORIGIN, NT_ORIGIN);
	}

	return(_kio.ki_origin);
}

/*
 *	getnodetype
 *
 *	Returns:	- local node type
 */
int4
getnodetype()

{
	return(getrtype(getnodeid()));
}
