/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: tcp_low.h,v 1.1 2001/01/10 20:00:32 jsquyres Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _TCP_LOW_H
#define _TCP_LOW_H

/*
 * public functions
 */
int			_tcp_advmultiple(void);
int			_tcp_adv1(void);
int			_tcp_proc_read_env(struct c2c_proc *ps);
int			_tcp_req_send_long(struct c2c_proc *ps,
					   MPI_Request req);
int			_tcp_req_send_short(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_send_synch(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_recv(struct c2c_proc *ps,
				      MPI_Request req);
int			_tcp_req_probe(struct c2c_proc *ps,
				       MPI_Request req);
int			_tcp_buffered_adv(MPI_Request req,
					  struct cbuf_msg *msg);
int			_tcp_fastsend(char *buf,
				      int  size,
				      struct c2c_proc *ps,
				      int dest,
				      int tag,
				      MPI_Comm comm);
int			_tcp_fastrecv(char *buf,
				      int *size,
				      struct c2c_proc *ps,
				      int src,
				      int *tag,
				      MPI_Comm comm,
				      int *seqnum);

/*
 * public variables
 */
extern int			_tcp_nio;	/* # processes doing tcp io */
extern int			_tcp_sockmax;	/* max. tcp io socket num. */
extern fd_set			_tcp_read;	/* read sockets */
extern fd_set			_tcp_write;	/* write sockets */
extern fd_set			_tcp_except;	/* exception sockets */
extern fd_set			_tcp_block;	/* blocked mode socket? */
extern fd_set			_tcp_eoferr;	/* eof on socket is error? */
extern MPI_Request		_tcp_lastreq;	/* last tcp request */
extern struct c2c_proc		*_tcp_smap[FD_SETSIZE];	/* maps socket fd to process */

#endif /* _TCP_LOW_H */
