/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: wtime.c,v 6.3 1999/12/31 21:27:43 jsquyres Exp $
 *
 *	Function:	- return wall clock time
 *	Returns:	- wall clock time in seconds
 */

#include <mpi.h>
#include <mpisys.h>
#include <net.h>

/*@
MPI_Wtime - Returns an elapsed time on the calling processor

Return value:

Time in seconds since an arbitrary time in the past.

Notes:

This is intended to be a high-resolution, elapsed (or wall) clock.
See 'MPI_Wtick' to determine the resolution of 'MPI_Wime'.  If the
attribute 'MPI_WTIME_IS_GLOBAL' is defined and true, then the value is
synchronized across all processes in 'MPI_COMM_WORLD'.

Notes for Fortran:

This function is declared as 'DOUBLE PRECISION MPI_WTIME()' in
Fortran.

.seealso: MPI_Wtick, MPI_Comm_get_attr

.N ACK
@*/
double MPI_Wtime(void)
{
	return(ttime());
}
