/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: wtick.c,v 6.4 1999/12/31 21:27:43 jsquyres Exp $
 *
 *	Function:	- return timer resolution
 *	Returns:	- time resolution in seconds
 */

#include <mpi.h>
#include <mpisys.h>
#include <net.h>

/*@
  MPI_Wtick - Returns the resolution of MPI_Wtime

Return value:

Time in seconds of resolution of 'MPI_Wtime'.

Notes for Fortran:

This is function is declared as 'DOUBLE PRECISION MPI_WTICK()' in
Fortran.

.seealso: MPI_Wtime  

.N ACK
@*/
double MPI_Wtick(void)
{
	static double	tick = 0.0;
	double		t;
	int		i;

	if (tick == 0.0) {

		tick = ttime();
		tick = ttime() - tick;
		
		for (i = 0; i < 10; i++) {
			t = ttime();
			t = ttime() - t;

			if (t < tick) {
				tick = t;
			}
		}

		tick = (tick > 0.0) ? tick : 1.0e-6;
	}

	return(tick);
}
