/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: tgettrue.c,v 1.2 2001/02/03 19:50:13 bbarrett Exp $
 *
 *	Function:	- get true lower bound and extent of datatype
 *	Accepts:	- datatype
 *			- true lower bound (out)
 *			- true extent (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
   MPI_Type_get_true_extent - Get true lower bound and extent of datatype

Input Parameter:
+ dtype - datatype to get information on

Output Parameters:
+ lb - true lower bound of datatype
- extent - true size of datatype

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG
.N MPI_ERR_TYPE

.seealso MPI_Type_get_extent(3), MPI_Type_extent(3), MPI_Type_create_resized(3)

.N WEB
@*/

int
MPI_Type_get_true_extent(MPI_Datatype dtype, MPI_Aint *lb, 
			 MPI_Aint *extent)
{
	lam_initerr();
	lam_setfunc(BLKMPITTEXTENT);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITTEXTENT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (lb == 0 || extent == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITTEXTENT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*lb = dtype->dt_datalow;
		*extent = dtype->dt_dataup - dtype->dt_datalow;
	}

	lam_resetfunc(BLKMPITTEXTENT);
	return(MPI_SUCCESS);
}
