/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: keycreate.c,v 6.6 1999/12/31 21:27:32 jsquyres Exp $
 *
 *	Function:	- create an attribute key
 *	Accepts:	- copy function
 *			- delete function
 *			- key value (out)
 *			- extra state info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>


/*@

MPI_Keyval_create - Generates a new communicator attribute key

Input Parameters:
. cpyfunc - Copy callback function for 'keyval' 
. delfunc - Delete callback function for 'keyval' 
. extra - Extra state for callback functions 

Output Parameter:
. key - key value for future access (integer) 

.N Wrapper MPI_Comm_create_keyval

.N ACK
@*/
int MPI_Keyval_create(MPI_Copy_function *cpyfunc, 
		      MPI_Delete_function *delfunc, 
		      int *key, void *extra)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIKEYCREATE);

	err = lam_keyval_create((void_fn *) cpyfunc, (void_fn *) delfunc, 
				key, extra, LAM_AKCOMM);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIKEYCREATE, err));
	}

	lam_resetfunc_m(BLKMPIKEYCREATE);
	return(MPI_SUCCESS);
}
