/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infogetnth.c,v 6.5 2001/02/03 20:24:38 jsquyres Exp $
 *
 *	Function:	- get n'th key in info object
 *	Accepts:	- info
 *			- n
 *			- key (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <string.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
  MPI_Info_get_nthkey - Get a key indexed by integer from an 'MPI_Info' object

int MPI_Info_get_nthkey(MPI_Info info, int n, char *key)

Input Parameters:
+ info - info object (handle)
- n - index of key to retrieve (integer)

Output Parameter:
. key - character string of at least 'MPI_MAX_INFO_KEY' characters

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N WEB
@*/
int MPI_Info_get_nthkey(MPI_Info info, int n, char *key)
{
	struct _infoent	*p;			/* key/value pair */
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPIINFOGETNTHKEY);

	if (info == 0 || n >= al_count(info->info_list) || key == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOGETNTHKEY,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	for (p = al_top(info->info_list); n > 0; n--) {
		p = al_next(info->info_list, p);
	}

	strcpy(key, p->ie_key);

	lam_resetfunc_m(BLKMPIINFOGETNTHKEY);
	return(MPI_SUCCESS);
}
