/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: waitall_f.c,v 6.4.2.1 2001/11/09 20:57:51 brbarret Exp $
 *
 *	Function:	- MPI_Waitall F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_waitall_(c, rqs, sts, ierr)

int			*c, *rqs, *sts, *ierr;

{
	MPI_Request	*reqs;
	MPI_Status	*stats;
	int		i;

	if (*c > 0) {
		reqs = (MPI_Request *) malloc((*c) * sizeof(MPI_Request));
		if (reqs == 0) {
			lam_setfunc(BLKMPIWAITALL);
			*ierr = lam_err_comm(MPI_COMM_WORLD,
						MPI_ERR_OTHER, errno, "");
			return;
		}
	} else {
		reqs = 0;
	}

	for (i = 0; i < *c; ++i) {
		reqs[i] = GETHDL(rqs[i]);
	}

	if ((void *) sts == lam_F_statuses_ignore) {
		stats = LAM_MPI_C_STATUSES_IGNORE;
	}
	else if ((void *) sts == lam_F_status_ignore) {
		lam_setfunc(BLKMPIWAITALL);
		*ierr = lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0,
					"MPI_STATUS_IGNORE");
		return;
	}
	else {
		stats = (MPI_Status *) sts;
	}

	*ierr = MPI_Waitall(*c, reqs, stats);

	if (*ierr == MPI_SUCCESS) {
		for (i = 0; i < *c; ++i) {
			if (reqs[i] == LAM_MPI_C_REQUEST_NULL) {
				lam_F_free_hdl(rqs[i]);
				rqs[i] = -1;
			}
		}
	}

	free((char *) reqs);
}
