/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: ccreatekey.c,v 1.2 2001/02/03 21:56:03 bbarrett Exp $
 *
 *	Function:	- create a communicator attribute key
 *	Accepts:	- copy function
 *			- delete function
 *			- key (out)
 *			- extra state info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Comm_create_keyval - Create a communicator attribute key

Input Parameters:
+ cpyfunc - Copy callback function for comm_keyval
. delfunc - Delete callback function for comm_keyval
- extra - Extra status info

Output Parameter:
+ key - Key value for future access

.N IMPI_MPI2

.N fortran

.N Errors
.N MPI_SUCCESS

.seealso MPI_Comm_free_keyval(3), MPI_Comm_set_attr(3), MPI_Comm_get_attr(3), MPI_Comm_delete_attr(3)

.N WEB
@*/

int
MPI_Comm_create_keyval(MPI_Comm_copy_attr_function *cpyfunc, 
		       MPI_Comm_delete_attr_function *delfunc, 
		       int *key, void *extra)
{
        int 		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPICOMMCREATEKEYVAL);

	err = lam_keyval_create((void_fn *) cpyfunc, (void_fn *) delfunc, 
				key, extra, LAM_AKCOMM);

	if (err != MPI_SUCCESS) {
	    return(lam_errfunc(MPI_COMM_WORLD, BLKMPICOMMCREATEKEYVAL, err));
	}

	lam_resetfunc_m(BLKMPICOMMCREATEKEYVAL);
	return(MPI_SUCCESS);
}
