/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: lamthreads.h,v 6.1 1999/12/29 14:11:09 jsquyres Exp $
 *
 *	Function:	- header for LAM thread interface
 */

#ifndef _MPI_LAM_THREADS_H
#define _MPI_LAM_THREADS_H

#include <lam_config.h>


/*
 * types
 */
typedef struct {
  lam_real_mutex_t mutex;
  lam_thread_t thread;
} lam_mutex_t;

/*
 * Main LAM thread globals
 */
extern int		lam_thread_level;
extern lam_thread_t	lam_main_thread;
extern lam_mutex_t	lam_mpi_mutex;
extern lam_mutex_t	lam_updown_mutex;


/*
 * LAM thread interface
 */
void		lam_thread_init(int requested, int *pprovided);
lam_thread_t	lam_thread_self(void);
int		lam_thread_compare(lam_thread_t a, lam_thread_t b);
void		lam_thread_finalize(void);

/*
 * LAM mutex interface
 */
void		lam_mutex_init(lam_mutex_t *mutex);
void		lam_mutex_lock(lam_mutex_t *mutex);
int		lam_mutex_is_owner(lam_mutex_t *mutex);
void		lam_mutex_unlock(lam_mutex_t *mutex);
void		lam_mutex_finalize(lam_mutex_t *mutex);


#endif	/* _MPI_LAM_THREADS_H */
