/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: rfwrite.c,v 6.3 1999/05/25 17:44:43 kmeyer1 Exp $
 *
 *      Function:       - writes to a file using remote filed
 *      Accepts:        - runtime file descriptor
 *                      - buffer ptr
 *                      - buffer length
 *      Returns:        - 0 or ERROR
 */

#include <string.h>
#include <unistd.h>

#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <terror.h>
#include <typical.h>

/*
 * global functions
 */
int4			lam_rfwrite();
int4			_lam_rfwrite();

/*
 * external variables
 */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * external functions
 */
extern int		_fdvalid();	/* check validity of file desc */


int4
lam_rfwrite(fd, buf, len)

int			fd;
CONST char		*buf;
int4			len;

{
/*
 * Do simple error checking.
 */
	if (_fdvalid(fd)) return((int4) LAMERROR);

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	return(_lam_rfwrite(_ufd[fd].fu_node, _ufd[fd].fu_tfd,
		_ufd[fd].fu_tflags, buf, len));
}

int4
_lam_rfwrite(node, tfd, tflags, buf, len)

int4			node;
int4			tfd;
int4			tflags;
CONST char		*buf;
int4			len;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */
	int4		tot_len = 0;	/* total length written */
	int4		pkt_len;	/* one packet length */

	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	nhead.nh_node = node;
	nhead.nh_flags = tflags & LAM_O_DMSG;

	nhead.nh_msg = (char *) buf;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Packetize output buffer.
 */
	do {
		request->fq_src_node = getnodeid();
		request->fq_src_event = -getpid();
		request->fq_req = FQWRITE;
		request->fq_tfd = tfd;

		nhead.nh_event = EVFILED;
		nhead.nh_type = 0;
		nhead.nh_length = (len > MAXNMSGLEN) ? MAXNMSGLEN : len;
		pkt_len = nhead.nh_length;
		request->fq_length = pkt_len;

		if (nsend(&nhead)) {
			ksigsetmask(mask);
			return(LAMERROR);
		}

		if (! (tflags & LAM_O_1WAY)) {
			nhead.nh_event = -getpid();
			nhead.nh_type = 0;
			nhead.nh_length = 0;

			if (nrecv(&nhead)) {
				ksigsetmask(mask);
				return(LAMERROR);
			}

			if (reply->fr_errno != 0) {
				ksigsetmask(mask);
				errno = reply->fr_errno;
				return(LAMERROR);
			}

			else if (reply->fr_ret != pkt_len) {
				len = 0;
			}

			else {
				len -= pkt_len;
				nhead.nh_msg += pkt_len;
			}
		} else {
			reply->fr_ret = pkt_len;
			len -= pkt_len;
			nhead.nh_msg += pkt_len;
		}

		tot_len += reply->fr_ret;
	} while (len > 0);

	ksigsetmask(mask);
	return(tot_len);
}

/*
 * backwards compatibility
 */
int4 rfwrite(fd, buf, len) int fd; CONST char *buf; int4 len;
	{ return(lam_rfwrite(fd, buf, len)); }
