/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: trdrain_mpi.c,v 6.2 1999/05/24 16:56:52 kmeyer1 Exp $
 *
 *	Function:	- unloads trace data for one MPI world
 *	Accepts:	- trace file desc. opened for append
 *			- GPS array of world
 *			- GPS array length
 *			- get/forget flag
 *			- delay period in secs after flush signal
 */

#include <unistd.h>

#include <lam_ksignal.h>
#include <app_mgmt.h>
#include <mpitrace.h>
#include <preq.h>
#include <trreq.h>
#include <typical.h>

int
trdrain_mpi(fd, world, nworld, keep, flush_delay)

int   			fd;    
struct _gps		*world;
int			nworld;
int			keep;
int			flush_delay;

{
	int		i;
	int		(*drain)();

	drain = keep ? lam_rtrfget : lam_rtrfforget;
/*
 * Signal everybody to flush in-process trace buffers to the daemon.
 */
	if (flush_delay >= 0) {

		for (i = 0; i < nworld; i++) {
			rpdoom(world[i].gps_node, SELECT_PID,
					world[i].gps_pid, LAM_SIGTRACE);
		}

		if (flush_delay > 0) {
			sleep((unsigned) flush_delay);
		}
	}
/*
 * Drain the init/on/off traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRONOFF, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the communicator traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRCOMM, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the datatype traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRDTYPE, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}
/*
 * Drain the runtime traces.
 */
	for (i = 0; i < nworld; i++) {

		if ((*drain)(world[i].gps_node, TRRUNTIME, world[i].gps_pid,
				fd) < 0) return(LAMERROR);
	}

	return(0);
}
