/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: iod.int.c,v 6.5 2000/02/08 10:29:22 jsquyres Exp $
 *
 *	Function:	- internal IO daemon
 */

#include <typical.h>

/*
 * public functions
 */
void			(*(iod()))();
void			io_accept();
void			io_register();
void			io_deregister();

/*
 * external functions
 */
extern void		kio_intr();
extern void		kio_intr_clr();
extern void		io_forward();
extern void		io_new();

/*
 *	iod
 *
 *	Function:	- server loop
 */
void (*(
iod()))()

{
	return((void (*)()) iod);
}

/*
 *	io_accept
 *
 *	Function:	- prepare to accept client connections
 *	Accepts:	- IO server file descriptor
 */
void
io_accept(fd)

int			fd;

{
	kio_intr(fd, io_new, FALSE);
}

/*
 *	io_register
 *
 *	Function:	- register a new client connection
 *			- iod will now read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_register(fd)

int			fd;

{
	kio_intr(fd, io_forward, FALSE);
}

/*
 *	io_deregister
 *
 *	Function:	- deregister a client connection
 *			- iod will no longer read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_deregister(fd)

int			fd;

{
	kio_intr_clr(fd);
}
