dnl -*- shell-script -*-

#
# $Id: lam_get_fortran_alignment.m4,v 1.1.2.1 2001/11/09 20:53:13 brbarret Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_GET_FORTRAN_ALIGNMENT,[
# Determine FORTRAN datatype size.
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(alignment of FORTRAN $1)
lam_ac_align_fn=
if test "x$lam_ac_doubleunder" = xy || test "x$lam_ac_singleunder" = xy; then
    lam_ac_align_fn=align_
else
    if test "x$lam_ac_nounder" = xy; then
	lam_ac_align_fn=align
    else
	if test "x$lam_ac_caps" = xy; then
	    lam_ac_align_fn=ALIGN
	else
	    AC_MSG_ERROR(FORTRAN external naming convention undefined)
	fi
    fi
fi
if test -n "$lam_ac_align_fn"; then
cat > conftestf.f <<EOF
      program falign
      external ALIGN
      $1  w,x,y,z
      CHARACTER a,b,c
      common /foo/a,w,b,x,y,c,z
      call ALIGN(w,x,y,z)
      end
EOF
cat > conftest.c <<EOF
#include <stdio.h>
#ifdef __cplusplus
extern "C" {
void exit(int);
#endif
void $lam_ac_align_fn(char *w, char *x, char *y, char *z)
{   unsigned long aw, ax, ay, az;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    aw = (unsigned long) w;
    ax = (unsigned long) x;
    ay = (unsigned long) y;
    az = (unsigned long) z;
    if (! ((aw%16)||(ax%16)||(ay%16)||(az%16))) fprintf(f, "%d\n", 16);
    else if (! ((aw%12)||(ax%12)||(ay%12)||(az%12))) fprintf(f, "%d\n", 12);
    else if (! ((aw%8)||(ax%8)||(ay%8)||(az%8))) fprintf(f, "%d\n", 8);
    else if (! ((aw%4)||(ax%4)||(ay%4)||(az%4))) fprintf(f, "%d\n", 4);
    else if (! ((aw%2)||(ax%2)||(ay%2)||(az%2))) fprintf(f, "%d\n", 2);
    else fprintf(f, "%d\n", 1); 
    fclose(f);
}
#ifdef __cplusplus
}
#endif
EOF
$CC $CFLAGS -c conftest.c 1>&5 2>&1
if test ! -s conftest.o; then
    AC_MSG_WARN(error compiling/running conftest)
else
    $F77 $FFLAGS conftestf.f conftest.o -o conftest  1>&5 2>&1
    if test -s conftest && (./conftest; exit) 2>/dev/null; then
	lam_ac_alignment=`cat conftestval`
	AC_MSG_RESULT $lam_ac_alignment
	if test -n "$2"; then
	    AC_DEFINE_UNQUOTED($2,$lam_ac_alignment)
	fi
    else
	AC_MSG_WARN(error compiling/running conftest)
    fi
fi
fi
/bin/rm -f conftest*])dnl
