/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: mpil_trace.c,v 6.2 1999/05/25 22:08:09 kmeyer1 Exp $
 *
 *	Function:	- toggles tracing status
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 *	MPIL_Trace_on
 *
 *	Function:	- enables tracing; begins segment
 */
int
MPIL_Trace_on()

{
	int		err;			/* error code */
	int		trmodesave;		/* save trace mode */
/*
 * This is a NOP if trace mode is off.
 */
	if ( ! (_kio.ki_rtf & RTF_TRACE)) return(MPI_SUCCESS);

	lam_initerr();
	lam_setfunc(BLKMPILTRACEON);
/*
 * Synchronize. We don't want to trace it though!
 */
	trmodesave = _kio.ki_rtf & RTF_TRSWITCH;
	_kio.ki_rtf &= ~RTF_TRSWITCH;
	
	err = MPI_Barrier(MPI_COMM_WORLD);

	_kio.ki_rtf |= trmodesave;
	
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEON, err));
	}
/*
 * Turn tracing on.
 */
	if (lam_tr_on() < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEON,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	
	lam_resetfunc(BLKMPILTRACEON);
	return(MPI_SUCCESS);
}

/*
 *	MPIL_Trace_off
 *
 *	Function:	- disables tracing; ends segment
 */
int
MPIL_Trace_off()

{
	int		err;			/* error code */
	int		trmodesave;		/* save trace mode */
/*
 * This is a NOP if trace mode is off.
 */
	if ( ! (_kio.ki_rtf & RTF_TRACE)) return(MPI_SUCCESS);
	
	lam_initerr();
	lam_setfunc(BLKMPILTRACEOFF);
/*
 * Synchronize. We don't want to trace it though!
 */
	trmodesave = _kio.ki_rtf & RTF_TRSWITCH;
	_kio.ki_rtf &= ~RTF_TRSWITCH;

	err = MPI_Barrier(MPI_COMM_WORLD);

	_kio.ki_rtf |= trmodesave;

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEOFF, err));
	}
/*
 * Turn tracing off.
 */
	if (lam_tr_off() < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPILTRACEOFF,
				lam_mkerr(MPI_ERR_OTHER, errno)));
	}
	
	lam_resetfunc(BLKMPILTRACEOFF);
	return(MPI_SUCCESS);
}
