/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *
 *	$Id: args.h,v 6.8 1999/10/03 23:18:28 jsquyres Exp $
 *
 *	Function:	- command line argument parsing
 */

#ifndef _ARGS
#define _ARGS

#include "lam.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * argument vector package
 */
extern int	sfh_argv_add __ARGS((int *, char ***, char *));
extern int	sfh_argv_count __ARGS((char **));
extern void	sfh_argv_free __ARGS((char **));
extern char	**sfh_argv_break __ARGS((const char *, int));
extern char	**sfh_argv_dup __ARGS((char **));
extern char	*sfh_argv_glue __ARGS((char **, int, unsigned int));
extern unsigned int
		sfh_argv_len __ARGS((char **));

/*
 * backwards compatible option interfaces
 */
extern int	argvadd __ARGS((int *argc,
				char ***argv, const char *arg));
extern int	argvcount __ARGS((char **argv));
extern int	argvlen __ARGS((char **argv));
extern char	**argvdup __ARGS((char **argv));
extern char	*argvglue __ARGS((char **argv, int delim, int maxlen));
extern char	**argvbreak __ARGS((const char *args, int delim));
extern void	argvfree __ARGS((char **argv));
		
extern int	do_args __ARGS((int *argcp, char **argv));
extern int	expand_nodes __ARGS((void));
extern int	get_2nd_let __ARGS((int let));
extern int	intparam __ARGS((int c, int *p));
extern int	opt_chosen __ARGS((int o));
extern int	opt_taken __ARGS((int let));
extern int	xtoi __ARGS((char **cpp, int *ip));
extern char	*getparam __ARGS((int let));
extern void	exclusive __ARGS((const char *str));
extern void	followed __ARGS((const char *str));
extern void	free_nodes __ARGS((void));
extern void	twoletter __ARGS((const char *str));
extern void	validopts __ARGS((const char *str));

/*
 * ID parsing package
 */
extern int	nid_parse __ARGS((int *argc, char **argv));
extern int	pid_parse __ARGS((int *argc, char **argv));
extern int4	nid_count __ARGS((void));
extern int4	nid_parse1 __ARGS((char *s));
extern char	*nid_fmt __ARGS((int4 node));
extern void	nid_get __ARGS((int *ixp, int *idp, int *flp));
extern void	pid_get __ARGS((int *ixp, int *idp, int *flp));
extern void	nid_free __ARGS((void));
extern void	pid_free __ARGS((void));
extern void	nid_usage __ARGS((void));

/*
 * backwards compatible ID interfaces
 */
extern int	parse_nodes __ARGS((int *argc, char **argv));
extern int	parse_procs __ARGS((int *argc, char **argv));
extern int4	mnnodeid __ARGS((const char *string));
extern char	*mnemonic __ARGS((int4 node));
extern void	getnode __ARGS((int *ixp, int *idp, int *flagsp));
extern void	getproc __ARGS((int *ixp, int *idp, int *flagsp));
extern void	mnusage __ARGS((void));

/*
 * Other things that are in libargs.a, currently for lack of a better
 * place to put them
 */
extern void     show_help __ARGS((char *program, char *topic, ...));
#if !HAVE_SNPRINTF
#define snprintf lam_snprintf
#endif
#if !LAM_HAVE_snprintf_PROTO
extern int      snprintf __ARGS((char *str, int len, char *fmt, ...));
#endif
extern int      lam_snprintf __ARGS((char *str, int len, char *fmt, ...));

#ifdef __cplusplus
}
#endif

#endif	/* _ARGS */
